package com.digiwin.athena.constant;

import lombok.Getter;

import java.util.Arrays;
import java.util.List;

/**
 * @author yueyyc
 * @version 1.0
 * @date 2022/11/7 11:19
 */
public class StatementConstant {
    @Getter
    protected static final List<String> PATTERN_TBB = Arrays.asList("STATEMENT", "MOBI-STATEMENT");
    @Getter
    protected static final List<String> PATTERN_ABI = Arrays.asList("STATEMENT");
    @Getter
    protected static final List<String> PATTERN_CUSTOM = Arrays.asList("STATEMENT");
    @Getter
    protected static final List<String> CATEGORY_TBB = Arrays.asList("STATEMENT");
    @Getter
    protected static final List<String> CATEGORY_ABI = Arrays.asList("ABI-STATEMENT");
    @Getter
    protected static final List<String> CATEGORY_CUSTOM = Arrays.asList("CUSTOM-STATEMENT", "CUSTOM-STATEMENT-DETAIL");

    public static final String CREATE_TBB = "/tbb-system/platform_integration/create_report";
    public static final String UPDATE_TBB = "/tbb-system/platform_integration/update_report_info";
    public static final String DELETE_TBB = "/tbb-system/platform_integration/delete_report/{}";//{id}
    public static final String COPY_TBB = "/tbb-system/platform_integration/copy_report";
    public static final String PUBLISH_TBB = "/tbb-system/platform_integration/publish_report";
    public static final String COPY_APP_TBB = "/tbb-system/platform_integration/copy_appcode";
    public static final String DELETE_APP_TBB = "/tbb-system/platform_integration/delete_appcode/";

    public static final String CHECKOUT_BRANCH = "/tbb-system/platform_integration/checkout_branch";

    public static final String SYNC_TBB = "/tbb-system/platform_integration/update_dataSourceInfo";

    public static final String TBB_NAVIGATION_BAR = "/tbb-system/platform_integration/checkPermission";

    public static final String CREATE_ABI = "/abi/lcdp.rpt.create?@routerKey={}&@ReportKey={}";
    public static final String UPDATE_ABI = "/abi/lcdp.rpt.update.caption?@routerKey={}&@ReportKey={}";
    public static final String DELETE_ABI = "/abi/lcdp.rpt.delete?@routerKey={}&@ReportKey={}";
    public static final String COPY_ABI = "/abi/lcdp.rpt.clone?@routerKey={}&@ReportKey={}";
    public static final String PUBLISH_ABI = "/abi/lcdp.rpt.release?@routerKey={}&@ReportKey={}";

    //根据应用删除abi所有报表
    public static final String DELETE_APPLICATION_ABI = "/abi/lcdp.rpt.deleteApp?@routerKey={}&@ReportKey={}";

    //根据应用删除tbb所有报表
    public static final String DELETE_APPLICATION_TBB = "/tbb-system/platform_integration/remove_appcode";

    //根据应用code恢复tbb报表
    public static final String RECOVERY_APPLICATION_TBB = "/tbb-system/platform_integration/recover_appcode";


    //根据应用删除tbb所有报表
    public static final String FIND_ABI_REPORT = "/abi/analyse/attribute.do";


}
