package com.digiwin.athena.utils;

import cn.hutool.core.lang.Snowflake;

import java.security.SecureRandom;
import java.util.Random;

public class SnowflakeToHexStrUtil {

    private static final SecureRandom random = new SecureRandom();

    /**
     * 雪花算法生成的id转16进制
     *
     */
    public static String snowflakeToHex() {
        // 生成雪花算法 ID
        Snowflake snowflake = new Snowflake(1, 1);
        long id = snowflake.nextId();

        // 增加随机数
        long randomSuffix = random.nextInt(10000); // 随机后缀
        long customId = (id << 16) | randomSuffix; // 左移并拼接随机数

        // 转为 16 进制
        return String.format("%016x", customId);
    }

    public static void main(String[] args) {
        String s = snowflakeToHex();
        System.out.println(s);

    }
}
