package com.digiwin.athena.constant.enumconstant;

import lombok.Getter;
import lombok.Setter;

/**
 * @Description 机制相关枚举值
 * @Author liugl
 * @Date 2024/6/27 13:12
 **/
public interface MechanismEnum {
	/**
	 * 执行目标类型
	 */
	enum TargetSourceType {
		TASK_SOURCE("taskSource", "项目任务"),
		PROJECT_SOURCE("projectSource", "发起项目"),
		DATA_ENTRY_SOURCE("dataEntrySource", "基础资料");

		@Getter
		@Setter
		private String code;

		@Getter
		@Setter
		private String name;
		/**
		 * 有参构造
		 * @param code
		 * @param name
		 */
		TargetSourceType(String code, String name) {
			this.code = code;
			this.name = name;
		}
	}
}
