/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.utils;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JSUtil.class);

    public static <T> T eval(String jsStr, Object param, Class<T> returnType) {
        try (Context context = Context.newBuilder((String[])new String[]{"js"}).build();){
            Value bindings = context.getBindings("js");
            Map map = BeanUtil.beanToMap((Object)param, (String[])new String[0]);
            map.forEach((arg_0, arg_1) -> ((Value)bindings).putMember(arg_0, arg_1));
            Value result = context.eval("js", (CharSequence)jsStr);
            Object object = JSUtil.convert(result, returnType);
            return (T)object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T evalResponse(String jsStr, String param, Class<T> returnType) {
        try (Context context = Context.newBuilder((String[])new String[]{"js"}).build();){
            Value bindings = context.getBindings("js");
            bindings.putMember("responseJSON", (Object)param);
            bindings.putMember("log", (Object)log);
            String js = "(function() {const response = JSON.parse(responseJSON);" + jsStr + "})();";
            Value result = context.eval("js", (CharSequence)js);
            Object object = JSUtil.convert(result, returnType);
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeException("js\u6267\u884c\u5f02\u5e38", e);
        }
    }

    public static JSONObject evalRequest(String jsStr, JSONObject requestContext) {
        JSONObject jSONObject;
        block8: {
            Context context = Context.newBuilder((String[])new String[]{"js"}).allowHostAccess(HostAccess.ALL).build();
            try {
                Value bindings = context.getBindings("js");
                bindings.putMember("requestContext", (Object)requestContext);
                bindings.putMember("log", (Object)log);
                String js = "(function() {" + jsStr + "})();";
                Value result = context.eval("js", (CharSequence)js);
                jSONObject = JSONObject.parseObject((String)requestContext.toJSONString());
                if (context == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("js\u6267\u884c\u5f02\u5e38", e);
                }
            }
            context.close();
        }
        return jSONObject;
    }

    public static <T> Object evalDependencyRule(String jsStr, String param, Class<T> returnType) {
        Object object;
        block8: {
            Context context = Context.newBuilder((String[])new String[]{"js"}).allowHostAccess(HostAccess.ALL).allowHostClassLookup(s -> true).build();
            try {
                Value bindings = context.getBindings("js");
                bindings.putMember("assetJSON", (Object)param);
                bindings.putMember("log", (Object)log);
                String js = "(function() {const asset = JSON.parse(assetJSON);" + jsStr + " return handle();})();";
                Value result = context.eval("js", (CharSequence)js);
                object = JSUtil.convert(result, returnType);
                if (context == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("js\u6267\u884c\u5f02\u5e38", e);
                }
            }
            context.close();
        }
        return object;
    }

    public static void main(String[] args) {
        String jsStr = "function handle(){const data=JSON.parse(asset.businessData);let arr=[];data.items.forEach(item=>{arr.push({\"targetType\":\"JMX_PRODUCT\",\"targetCode\":item.product_id,\"type\":\"dep\",\"targetManageContext\":{\"application\":asset.manageContext.application}})});return arr}";
        String param = "{\"adpVersion\":\"0\",\"assetId\":\"AT_1050a29983871afb\",\"assetName\":\"\u8ba2\u535501\",\"businessData\":\"{\\\"id\\\":4,\\\"name\\\":\\\"\u8ba2\u535501\\\",\\\"items\\\":[{\\\"product_id\\\":\\\"PROD-2001-0000\\\"},{\\\"product_id\\\":\\\"PROD-2001-0001\\\"}],\\\"branch\\\":\\\"dev\\\",\\\"status\\\":\\\"PAID\\\",\\\"order_id\\\":\\\"ORD-20251205-0001\\\",\\\"created_at\\\":\\\"2025-12-05T10:15:00+00:00\\\",\\\"application\\\":\\\"jmx-eshopAT\\\",\\\"total_amount\\\":9597}\",\"code\":\"ORD-20251205-0001\",\"createBy\":\"jiangmx@digiwin.com\",\"createDate\":1765363410525,\"editBy\":\"jiangmx@digiwin.com\",\"editDate\":1765364499074,\"manageContext\":{\"application\":\"jmx-eshopAT\",\"dataId\":\"4\",\"branch\":\"dev\"},\"objectId\":\"69394ed2797f68655ef7c0fc\",\"showFields\":{},\"source\":\"SD\",\"type\":\"JMX_ORDER\"}";
        try (Context context = Context.newBuilder((String[])new String[]{"js"}).allowHostAccess(HostAccess.ALL).allowHostClassLookup(s -> true).build();){
            Value bindings = context.getBindings("js");
            bindings.putMember("assetJSON", (Object)param);
            bindings.putMember("log", (Object)log);
            String js = "(function() {const asset = JSON.parse(assetJSON);" + jsStr + " return handle();})();";
            Value result = context.eval("js", (CharSequence)js);
            System.out.println(result);
        }
        catch (Exception e) {
            throw new RuntimeException("js\u6267\u884c\u5f02\u5e38", e);
        }
    }

    private static <T> Object convert(Value result, Class<T> returnType) {
        ObjectMapper mapper = new ObjectMapper();
        if (result.isNull()) {
            return null;
        }
        if (result.isString()) {
            String str = result.asString();
            if (returnType == String.class) {
                return returnType.cast(str);
            }
            try {
                return mapper.readValue(str, returnType);
            }
            catch (Exception exception) {
                log.error("JS \u8fd4\u56de\u5b57\u7b26\u4e32\uff0c\u4f46\u65e0\u6cd5\u8f6c\u6362\u6210\u76ee\u6807\u7c7b\u578b", (Throwable)exception);
                throw new RuntimeException("JS \u8fd4\u56de\u5b57\u7b26\u4e32\uff0c\u4f46\u65e0\u6cd5\u8f6c\u6362\u6210\u76ee\u6807\u7c7b\u578b\uff1a" + returnType.getName());
            }
        }
        if (result.fitsInInt() && returnType == Integer.class) {
            return returnType.cast(result.asInt());
        }
        if (result.fitsInLong() && returnType == Long.class) {
            return returnType.cast(result.asLong());
        }
        if (result.fitsInDouble() && (returnType == Double.class || returnType == Double.TYPE)) {
            return returnType.cast(result.asDouble());
        }
        if (result.isBoolean() && (returnType == Boolean.class || returnType == Boolean.TYPE)) {
            return returnType.cast(result.asBoolean());
        }
        if (result.hasArrayElements()) {
            Value iterator = result.getIterator();
            ArrayList<Object> res = new ArrayList<Object>();
            while (iterator.hasIteratorNextElement()) {
                Value iteratorNextElement = iterator.getIteratorNextElement();
                res.add(JSUtil.convert(iteratorNextElement, returnType));
            }
            return res;
        }
        if (result.hasMembers()) {
            Map map = (Map)result.as(Map.class);
            return mapper.convertValue((Object)map, returnType);
        }
        return result.as(returnType);
    }
}

