/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.rabbitMQ;

import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="rabbitmq.mdc")
@ConditionalOnProperty(name={"rabbitmq.mdc.open"}, havingValue="true")
public class RabbitMQConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RabbitMQConfig.class);
    public static final String EXCHANGE_NAME = "athena_designer_exchange";
    public static final String ASSET_DATA_ROUTE_KEY = "assetData.key";
    private String address;
    private String assetDataSyncQueueName;

    @Bean
    public DirectExchange exchange() {
        return new DirectExchange(EXCHANGE_NAME);
    }

    @Bean
    @ConditionalOnProperty(prefix="rabbitmq.mdc", name={"assetDataSyncQueueName"})
    public Queue assetDataSyncQueue() {
        return new Queue(this.assetDataSyncQueueName, true);
    }

    @Bean
    @ConditionalOnBean(name={"assetDataSyncQueue"})
    public Binding assetDataSyncQueueBinding(@Qualifier(value="assetDataSyncQueue") Queue queue, DirectExchange exchange) {
        return BindingBuilder.bind((Queue)queue).to(exchange).with(ASSET_DATA_ROUTE_KEY);
    }

    @Bean
    public ConnectionFactory connectionFactory() {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory();
        RabbitProperties properties = new RabbitProperties();
        properties.setAddresses(List.of(this.address));
        connectionFactory.setHost(properties.determineHost());
        connectionFactory.setPort(properties.determinePort());
        connectionFactory.setUsername(properties.determineUsername());
        connectionFactory.setPassword(properties.determinePassword());
        connectionFactory.setVirtualHost(properties.determineVirtualHost());
        return connectionFactory;
    }

    @Bean
    public RabbitTemplate rabbitTemplate(@Qualifier(value="connectionFactory") ConnectionFactory connectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(connectionFactory);
        return rabbitTemplate;
    }

    @Bean(name={"mdcMessageListenerContainer"})
    public SimpleRabbitListenerContainerFactory mdcMessageListenerContainer(@Qualifier(value="connectionFactory") ConnectionFactory connectionFactory) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setAcknowledgeMode(AcknowledgeMode.MANUAL);
        return factory;
    }

    @Bean(value={"manualAckContainerFactory"})
    public SimpleRabbitListenerContainerFactory manualAckContainerFactory(ConnectionFactory connectionFactory) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setAcknowledgeMode(AcknowledgeMode.MANUAL);
        factory.setMissingQueuesFatal(Boolean.valueOf(false));
        return factory;
    }

    @Generated
    public RabbitMQConfig() {
    }

    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public String getAssetDataSyncQueueName() {
        return this.assetDataSyncQueueName;
    }

    @Generated
    public void setAddress(String address) {
        this.address = address;
    }

    @Generated
    public void setAssetDataSyncQueueName(String assetDataSyncQueueName) {
        this.assetDataSyncQueueName = assetDataSyncQueueName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RabbitMQConfig)) {
            return false;
        }
        RabbitMQConfig other = (RabbitMQConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$assetDataSyncQueueName = this.getAssetDataSyncQueueName();
        String other$assetDataSyncQueueName = other.getAssetDataSyncQueueName();
        return !(this$assetDataSyncQueueName == null ? other$assetDataSyncQueueName != null : !this$assetDataSyncQueueName.equals(other$assetDataSyncQueueName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RabbitMQConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $assetDataSyncQueueName = this.getAssetDataSyncQueueName();
        result = result * 59 + ($assetDataSyncQueueName == null ? 43 : $assetDataSyncQueueName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RabbitMQConfig(address=" + this.getAddress() + ", assetDataSyncQueueName=" + this.getAssetDataSyncQueueName() + ")";
    }
}

