package com.digiwin.athena.constant;

/**
 * 流程节点枚举
 */
public enum ProcessNodeTypeEnum {

    START_FLOW("StartFlow","255"),// 开始节点（前端使用）
    START_EVENT("StartEvent","21845"),// 开始事件触发节点
    START_TIMER("StartTimer","255"),// 开始定时触发节点
    START_MANUAL("StartManual","255"),// 开始人工触发节点
    START_PROJECT("StartProject","255"),// 开始手动发起项目节点
    END_FLOW("EndFlow","255"),// 结束节点
    MANUAL_APPROVE("ManualApprove","255"),// 人工签核节点
    MANUAL_EXECUTION("ManualExecution","255"), // 人工关卡节点
    MANUAL_NOTIFICATION("ManualNotification","255"),// 人工知会节点
    AUTO_HTTP("AutoHttp","255"),// 自动HTTP节点
    AUTO_ESP("AutoEsp","255"),// 自动ESP节点
    AUTO_CALL_EVENT("AutoCallEvent","255"),// 自动事件节点
    AUTO_NOTIFY("AutoNotify","255"),// 自动消息通知节点
    MSG_SEND("MsgSend","255"),// 自动消息通知节点
    AUTO_SCRIPT("AutoScript","255"),// 自动脚本节点
    AUTO_SUB_PROCESS("AutoSubProcess","255"),// 自动子流程节点
    CONDITION_BRANCH("ConditionBranch","255"),// 条件分支节点
    CONDITION_BRANCH_START("ConditionBranchStart","255"),// 条件分支开始节点
    CONDITION_BRANCH_END("ConditionBranchEnd","255"),// 条件分支结束节点
    PARALLEL_BRANCH("ParallelBranch","255"),// 并行分支节点
    PARALLEL_GATEWAY_CONDITION_BRANCH("ParallelGatewayConditionBranch","255"),// 并行分支节点
    WAIT("Wait","255"),// 等待节点
    GLOBAL_SETTING("GlobalSetting","255"),// 全局设置
    Loop("Loop", "255"),//循环节点，壳子
    StartLoop("StartLoop", "255"),//循环开始节点
    EndLoop("EndLoop", "255");//循环结束节点


    private String nodeType;

    private String value;

    ProcessNodeTypeEnum(String nodeType, String value) {

        this.nodeType = nodeType;
        this.value = value;
    }

    public String getNodeType() {
        return nodeType;
    }

    public String getValue() {
        return value;
    }

}