package com.digiwin.athena.constant.modelDriven;

public enum ButtonEnum {

    SAVE("保存"),
    VALID("生效"),
    INVALID("失效"),
    DELETE("删除"),
    SEND_AUDIT("送审"),
    CANCEL_AUDIT("撤审"),
    ABOLISHED("作废");

    private String buttonName;

    ButtonEnum(String buttonName) {
        this.buttonName = buttonName;
    }

    public static boolean isTransactionNeed(String title) {
        if (SEND_AUDIT.buttonName.equals(title)||
                CANCEL_AUDIT.buttonName.equals(title)||
                ABOLISHED.buttonName.equals(title)){
            return true;
        }
        return false;
    }

    public static boolean isTransactionNotNeed(String title) {
        if (VALID.buttonName.equals(title)||
                INVALID.buttonName.equals(title)){
            return true;
        }
        return false;
    }

    public String getButtonName() {
        return buttonName;
    }
}
