package com.digiwin.athena.utils.operation.aspect;

import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.digiwin.athena.utils.operation.OperationTableNameConstants;
import com.digiwin.athena.utils.operation.OperationRecordWrapper;

import java.util.LinkedList;
import java.util.List;

/**
 * @author yueyyc
 * @version 1.0
 * @date 2023/3/7 15:21
 */
public class RecordCommitLocal {

    private static ThreadLocal<List<OperationRecordWrapper>> local = new ThreadLocal<>();

    public static void add(OperationRecordWrapper operationRecordWrapper) {
        //是业务表，且创建快照数据时，不记录操作日志
        if (!OperationTableNameConstants.FAVOURITE.equals(operationRecordWrapper.getTableName())
                && StrUtil.isNotBlank(CurThreadInfoUtils.getTemplateId())) {
            return;
        }
        if (null == local.get()) {
            List<OperationRecordWrapper> operationRecordWrapperList = new LinkedList<>();
            operationRecordWrapperList.add(operationRecordWrapper);
            local.set(operationRecordWrapperList);
        } else {
            local.get().add(operationRecordWrapper);
        }
    }

    public static List<OperationRecordWrapper> get() {
        return local.get();
    }

    public static void clear() {
        local.remove();
    }
}
