/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.utils;

import java.util.function.Function;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class RequestShareUtil {
    public static final InheritableThreadLocal<String> threadLocal = new InheritableThreadLocal();

    public static void shareToken(String token) {
        threadLocal.set(token);
    }

    public static String getToken() {
        return (String)threadLocal.get();
    }

    public static void remove() {
        threadLocal.remove();
    }

    public static <T> T computeIfAbsent(String key, Function<String, T> func) {
        RequestAttributes requestHodler = RequestContextHolder.getRequestAttributes();
        if (requestHodler == null) {
            return func.apply(key);
        }
        Object t = requestHodler.getAttribute(key, 0);
        if (t == null) {
            t = func.apply(key);
            requestHodler.setAttribute(key, t, 0);
        }
        return (T)t;
    }
}

