package com.digiwin.athena.utils;


import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import java.util.function.Function;

public class RequestShareUtil {

    public static final InheritableThreadLocal<String> threadLocal  = new InheritableThreadLocal<String>();

    public static void shareToken(String token) {
        threadLocal.set(token);
    }

    public static String getToken(){
        return threadLocal.get();
    }

    public static void remove(){
        threadLocal.remove();
    }

    public static <T> T computeIfAbsent(String key, Function<String, T> func) {
        RequestAttributes requestHodler = RequestContextHolder.getRequestAttributes();
        if (requestHodler == null) {
            return func.apply(key);
        }

        //noinspection unchecked
        T t = (T) requestHodler.getAttribute(key, RequestAttributes.SCOPE_REQUEST);
        if (t == null) {
            t = func.apply(key);
            requestHodler.setAttribute(key, t, RequestAttributes.SCOPE_REQUEST);
        }

        return t;
    }

}
