package com.digiwin.athena.utils.expression;


import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @see ExpressionResolver
 */
@Component
public class ExpressionUtil {
    public static final ExpressionResolver INSTANCE = new ExpressionResolver();


    public static String resolveToStr(String text, Object contextObj) {
        return INSTANCE.resolveToStr(text, contextObj);
    }

    /**
     * 解析字符串中的表达式
     * 支持格式: {@value ExpressionResolver#EXAMPLE}或直接的SpEL表达式
     *
     * @param text 包含表达式的文本
     * @return 解析后的文本
     */
    public static Object resolveStr(String text, Object contextObj) {
        return INSTANCE.resolveStr(text, contextObj);
    }

    public static Map<String, Object> resolveMap(Map<String, Object> obj, Object contextObj, String... expressionKeys) {
        return INSTANCE.resolveMap(obj, contextObj, expressionKeys);
    }

    public static <T> List<T> resolveList(List<T> obj, Object contextObj, String... expressionKeys) {
        return INSTANCE.resolveList(obj, contextObj, expressionKeys);
    }

    public static <T> T resolve(T obj, Object contextObj, ExpressionResolver.BeanAccessor<T> beanAccessor, String... expressionKeys) {
        return INSTANCE.resolve(obj, contextObj, beanAccessor, expressionKeys);
    }

    public static String wrapVarName(String varName) {
        return INSTANCE.wrapVarName(varName);
    }

}
