/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.config.mongodb;

import com.digiwin.athena.config.ExtendSimpleMongoRepository;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.config.MongoConfigurationSupport;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

@Configuration
@EnableMongoRepositories(basePackages={"com.digiwin.athena.mongodb.repository"}, repositoryBaseClass=ExtendSimpleMongoRepository.class)
@ConfigurationProperties(prefix="spring.data.mongodb")
public class MongodbConfig
extends MongoConfigurationSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MongodbConfig.class);
    public static final String BASE_PACKAGE = "com.digiwin.athena.mongodb.repository";
    public static final String MONGO_TEMPLATE_REF = "mongoTemplate";
    private String uri;
    private String database;
    private String testDatabase;
    private String masterDatabase;
    private String bakDatabase;
    private String tenantDatabase;
    private String runtimeDatabase;
    private String individualDevDatabase;
    private String individualTestDatabase;
    private String individualMasterDatabase;
    private String individualBakDatabase;

    @Bean
    @Primary
    public MongoClient mongoClient() {
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(new ConnectionString(this.uri)).applyToConnectionPoolSettings(builder -> builder.maxSize(30).minSize(10).maxConnectionIdleTime(1L, TimeUnit.MINUTES).maxConnectionLifeTime(1L, TimeUnit.MINUTES).maxWaitTime(2L, TimeUnit.MINUTES)).build();
        return MongoClients.create((MongoClientSettings)mongoClientSettings);
    }

    @Primary
    @Bean
    public MongoDatabaseFactory mongoDatabaseFactory() {
        log.error("database:" + this.database);
        log.error("masterDatabase:" + this.masterDatabase);
        log.error("bakDatabase:" + this.bakDatabase);
        log.error("tenantDatabase:" + this.tenantDatabase);
        return new SimpleMongoClientDatabaseFactory(this.mongoClient(), this.database);
    }

    @Bean
    public MongoDatabaseFactory testMongoDatabaseFactory() {
        return new SimpleMongoClientDatabaseFactory(this.mongoClient(), this.testDatabase);
    }

    @Bean
    public MongoDatabaseFactory masterMongoDatabaseFactory() {
        return new SimpleMongoClientDatabaseFactory(this.mongoClient(), this.masterDatabase);
    }

    @Bean
    public MongoDatabaseFactory bakMongoDatabaseFactory() {
        return new SimpleMongoClientDatabaseFactory(this.mongoClient(), this.bakDatabase);
    }

    @Bean
    public MongoDatabaseFactory tenantMongoDatabaseFactory() {
        return new SimpleMongoClientDatabaseFactory(this.mongoClient(), this.tenantDatabase);
    }

    @Bean
    public MongoDatabaseFactory runtimeMongoDatabaseFactory() {
        return new SimpleMongoClientDatabaseFactory(this.mongoClient(), this.runtimeDatabase);
    }

    @Bean
    public MongoDatabaseFactory individualDevMongoDatabaseFactory() {
        return new SimpleMongoClientDatabaseFactory(this.mongoClient(), this.individualDevDatabase);
    }

    @Bean
    public MongoDatabaseFactory individualTestMongoDatabaseFactory() {
        return new SimpleMongoClientDatabaseFactory(this.mongoClient(), this.individualTestDatabase);
    }

    @Bean
    public MongoDatabaseFactory individualMasterMongoDatabaseFactory() {
        return new SimpleMongoClientDatabaseFactory(this.mongoClient(), this.individualMasterDatabase);
    }

    @Bean
    public MongoDatabaseFactory individualBakMongoDatabaseFactory() {
        return new SimpleMongoClientDatabaseFactory(this.mongoClient(), this.individualBakDatabase);
    }

    @Primary
    @Bean
    public MongoTemplate mongoTemplate(MongoDatabaseFactory mongoDatabaseFactory, MappingMongoConverter mappingMongoConverter) throws Exception {
        return new MongoTemplate(mongoDatabaseFactory, (MongoConverter)mappingMongoConverter);
    }

    @Bean
    public MongoTemplate testMongoTemplate(@Qualifier(value="testMongoDatabaseFactory") MongoDatabaseFactory testMongoDatabaseFactory, @Qualifier(value="testMappingMongoConverter") MappingMongoConverter testMappingMongoConverter) throws Exception {
        return new MongoTemplate(testMongoDatabaseFactory, (MongoConverter)testMappingMongoConverter);
    }

    @Bean
    public MongoTemplate masterMongoTemplate(@Qualifier(value="masterMongoDatabaseFactory") MongoDatabaseFactory masterMongoDatabaseFactory, @Qualifier(value="masterMappingMongoConverter") MappingMongoConverter masterMappingMongoConverter) throws Exception {
        return new MongoTemplate(masterMongoDatabaseFactory, (MongoConverter)masterMappingMongoConverter);
    }

    @Bean
    public MongoTemplate bakMongoTemplate(@Qualifier(value="bakMongoDatabaseFactory") MongoDatabaseFactory bakMongoDatabaseFactory, @Qualifier(value="bakMappingMongoConverter") MappingMongoConverter bakMappingMongoConverter) throws Exception {
        return new MongoTemplate(bakMongoDatabaseFactory, (MongoConverter)bakMappingMongoConverter);
    }

    @Bean
    public MongoTemplate tenantMongoTemplate(@Qualifier(value="tenantMongoDatabaseFactory") MongoDatabaseFactory tenantMongoDatabaseFactory, @Qualifier(value="tenantMappingMongoConverter") MappingMongoConverter bakMappingMongoConverter) throws Exception {
        return new MongoTemplate(tenantMongoDatabaseFactory, (MongoConverter)bakMappingMongoConverter);
    }

    @Bean
    public MongoTemplate runtimeMongoTemplate(@Qualifier(value="runtimeMongoDatabaseFactory") MongoDatabaseFactory runtimeMongoDatabaseFactory, @Qualifier(value="runtimeMappingMongoConverter") MappingMongoConverter runtimeMappingMongoConverter) throws Exception {
        return new MongoTemplate(runtimeMongoDatabaseFactory, (MongoConverter)runtimeMappingMongoConverter);
    }

    @Bean
    public MongoTemplate individualDevMongoTemplate(@Qualifier(value="individualDevMongoDatabaseFactory") MongoDatabaseFactory individualDevMongoDatabaseFactory, @Qualifier(value="individualDevMappingMongoConverter") MappingMongoConverter individualDevMappingMongoConverter) throws Exception {
        return new MongoTemplate(individualDevMongoDatabaseFactory, (MongoConverter)individualDevMappingMongoConverter);
    }

    @Bean
    public MongoTemplate individualTestMongoTemplate(@Qualifier(value="individualTestMongoDatabaseFactory") MongoDatabaseFactory individualTestMongoDatabaseFactory, @Qualifier(value="individualTestMappingMongoConverter") MappingMongoConverter individualTestMappingMongoConverter) throws Exception {
        return new MongoTemplate(individualTestMongoDatabaseFactory, (MongoConverter)individualTestMappingMongoConverter);
    }

    @Bean
    public MongoTemplate individualMasterMongoTemplate(@Qualifier(value="individualMasterMongoDatabaseFactory") MongoDatabaseFactory individualMasterMongoDatabaseFactory, @Qualifier(value="individualMasterMappingMongoConverter") MappingMongoConverter individualMasterMappingMongoConverter) throws Exception {
        return new MongoTemplate(individualMasterMongoDatabaseFactory, (MongoConverter)individualMasterMappingMongoConverter);
    }

    @Bean
    public MongoTemplate individualBakMongoTemplate(@Qualifier(value="individualBakMongoDatabaseFactory") MongoDatabaseFactory individualBakMongoDatabaseFactory, @Qualifier(value="individualBakMappingMongoConverter") MappingMongoConverter individualBakMappingMongoConverter) throws Exception {
        return new MongoTemplate(individualBakMongoDatabaseFactory, (MongoConverter)individualBakMappingMongoConverter);
    }

    @Bean
    public MappingMongoConverter mappingMongoConverter(MongoDatabaseFactory mongoDatabaseFactory, MongoMappingContext context) throws Exception {
        return this.getMappingMongoConverter(new DefaultDbRefResolver(mongoDatabaseFactory), context);
    }

    @Bean
    public MappingMongoConverter testMappingMongoConverter(@Qualifier(value="testMongoDatabaseFactory") MongoDatabaseFactory testMongoDatabaseFactory, MongoMappingContext context) throws Exception {
        return this.getMappingMongoConverter(new DefaultDbRefResolver(testMongoDatabaseFactory), context);
    }

    @Bean
    public MappingMongoConverter masterMappingMongoConverter(@Qualifier(value="masterMongoDatabaseFactory") MongoDatabaseFactory masterMongoDatabaseFactory, MongoMappingContext context) throws Exception {
        return this.getMappingMongoConverter(new DefaultDbRefResolver(masterMongoDatabaseFactory), context);
    }

    @Bean
    public MappingMongoConverter bakMappingMongoConverter(@Qualifier(value="bakMongoDatabaseFactory") MongoDatabaseFactory bakMongoDatabaseFactory, MongoMappingContext context) throws Exception {
        return this.getMappingMongoConverter(new DefaultDbRefResolver(bakMongoDatabaseFactory), context);
    }

    @Bean
    public MappingMongoConverter tenantMappingMongoConverter(@Qualifier(value="tenantMongoDatabaseFactory") MongoDatabaseFactory tenantMongoDatabaseFactory, MongoMappingContext context) throws Exception {
        return this.getMappingMongoConverter(new DefaultDbRefResolver(tenantMongoDatabaseFactory), context);
    }

    @Bean
    public MappingMongoConverter runtimeMappingMongoConverter(@Qualifier(value="runtimeMongoDatabaseFactory") MongoDatabaseFactory runtimeMongoDatabaseFactory, MongoMappingContext context) throws Exception {
        return this.getMappingMongoConverter(new DefaultDbRefResolver(runtimeMongoDatabaseFactory), context);
    }

    @Bean
    public MappingMongoConverter individualDevMappingMongoConverter(@Qualifier(value="individualDevMongoDatabaseFactory") MongoDatabaseFactory individualDevMongoDatabaseFactory, MongoMappingContext context) throws Exception {
        return this.getMappingMongoConverter(new DefaultDbRefResolver(individualDevMongoDatabaseFactory), context);
    }

    @Bean
    public MappingMongoConverter individualTestMappingMongoConverter(@Qualifier(value="individualTestMongoDatabaseFactory") MongoDatabaseFactory individualTestMongoDatabaseFactory, MongoMappingContext context) throws Exception {
        return this.getMappingMongoConverter(new DefaultDbRefResolver(individualTestMongoDatabaseFactory), context);
    }

    @Bean
    public MappingMongoConverter individualMasterMappingMongoConverter(@Qualifier(value="individualMasterMongoDatabaseFactory") MongoDatabaseFactory individualMasterMongoDatabaseFactory, MongoMappingContext context) throws Exception {
        return this.getMappingMongoConverter(new DefaultDbRefResolver(individualMasterMongoDatabaseFactory), context);
    }

    @Bean
    public MappingMongoConverter individualBakMappingMongoConverter(@Qualifier(value="individualBakMongoDatabaseFactory") MongoDatabaseFactory individualBakMongoDatabaseFactory, MongoMappingContext context) throws Exception {
        return this.getMappingMongoConverter(new DefaultDbRefResolver(individualBakMongoDatabaseFactory), context);
    }

    private MappingMongoConverter getMappingMongoConverter(DefaultDbRefResolver mongoDbFactory, MongoMappingContext context) throws ClassNotFoundException {
        DefaultDbRefResolver dbRefResolver = mongoDbFactory;
        MappingMongoConverter converter = new MappingMongoConverter((DbRefResolver)dbRefResolver, (MappingContext)context);
        converter.setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper(null));
        converter.setCustomConversions((CustomConversions)this.customConversions());
        return converter;
    }

    protected String getDatabaseName() {
        return this.database;
    }

    public String getTenantDatabase() {
        return this.tenantDatabase;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getTestDatabase() {
        return this.testDatabase;
    }

    public void setTestDatabase(String testDatabase) {
        this.testDatabase = testDatabase;
    }

    public String getMasterDatabase() {
        return this.masterDatabase;
    }

    public void setMasterDatabase(String masterDatabase) {
        this.masterDatabase = masterDatabase;
    }

    public String getBakDatabase() {
        return this.bakDatabase;
    }

    public void setBakDatabase(String bakDatabase) {
        this.bakDatabase = bakDatabase;
    }

    public String getIndividualDevDatabase() {
        return this.individualDevDatabase;
    }

    public void setIndividualDevDatabase(String individualDevDatabase) {
        this.individualDevDatabase = individualDevDatabase;
    }

    public String getIndividualTestDatabase() {
        return this.individualTestDatabase;
    }

    public void setIndividualTestDatabase(String individualTestDatabase) {
        this.individualTestDatabase = individualTestDatabase;
    }

    public String getIndividualMasterDatabase() {
        return this.individualMasterDatabase;
    }

    public void setIndividualMasterDatabase(String individualMasterDatabase) {
        this.individualMasterDatabase = individualMasterDatabase;
    }

    public String getIndividualBakDatabase() {
        return this.individualBakDatabase;
    }

    public void setIndividualBakDatabase(String individualBakDatabase) {
        this.individualBakDatabase = individualBakDatabase;
    }

    public void setTenantDatabase(String tenantDatabase) {
        this.tenantDatabase = tenantDatabase;
    }

    public Map<String, String> getBranchDBNameMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (CurThreadInfoUtils.getIndividualCase() != null && CurThreadInfoUtils.getIndividualCase().booleanValue()) {
            map.put("develop", this.individualDevDatabase);
            map.put("test", this.individualTestDatabase);
            map.put("master", this.individualMasterDatabase);
            map.put("bak", this.individualBakDatabase);
        } else {
            map.put("develop", this.database);
            map.put("test", this.testDatabase);
            map.put("master", this.masterDatabase);
            map.put("bak", this.bakDatabase);
        }
        return map;
    }

    @Generated
    public MongodbConfig() {
    }

    @Generated
    public String getRuntimeDatabase() {
        return this.runtimeDatabase;
    }

    @Generated
    public void setRuntimeDatabase(String runtimeDatabase) {
        this.runtimeDatabase = runtimeDatabase;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MongodbConfig)) {
            return false;
        }
        MongodbConfig other = (MongodbConfig)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$testDatabase = this.getTestDatabase();
        String other$testDatabase = other.getTestDatabase();
        if (this$testDatabase == null ? other$testDatabase != null : !this$testDatabase.equals(other$testDatabase)) {
            return false;
        }
        String this$masterDatabase = this.getMasterDatabase();
        String other$masterDatabase = other.getMasterDatabase();
        if (this$masterDatabase == null ? other$masterDatabase != null : !this$masterDatabase.equals(other$masterDatabase)) {
            return false;
        }
        String this$bakDatabase = this.getBakDatabase();
        String other$bakDatabase = other.getBakDatabase();
        if (this$bakDatabase == null ? other$bakDatabase != null : !this$bakDatabase.equals(other$bakDatabase)) {
            return false;
        }
        String this$tenantDatabase = this.getTenantDatabase();
        String other$tenantDatabase = other.getTenantDatabase();
        if (this$tenantDatabase == null ? other$tenantDatabase != null : !this$tenantDatabase.equals(other$tenantDatabase)) {
            return false;
        }
        String this$runtimeDatabase = this.getRuntimeDatabase();
        String other$runtimeDatabase = other.getRuntimeDatabase();
        if (this$runtimeDatabase == null ? other$runtimeDatabase != null : !this$runtimeDatabase.equals(other$runtimeDatabase)) {
            return false;
        }
        String this$individualDevDatabase = this.getIndividualDevDatabase();
        String other$individualDevDatabase = other.getIndividualDevDatabase();
        if (this$individualDevDatabase == null ? other$individualDevDatabase != null : !this$individualDevDatabase.equals(other$individualDevDatabase)) {
            return false;
        }
        String this$individualTestDatabase = this.getIndividualTestDatabase();
        String other$individualTestDatabase = other.getIndividualTestDatabase();
        if (this$individualTestDatabase == null ? other$individualTestDatabase != null : !this$individualTestDatabase.equals(other$individualTestDatabase)) {
            return false;
        }
        String this$individualMasterDatabase = this.getIndividualMasterDatabase();
        String other$individualMasterDatabase = other.getIndividualMasterDatabase();
        if (this$individualMasterDatabase == null ? other$individualMasterDatabase != null : !this$individualMasterDatabase.equals(other$individualMasterDatabase)) {
            return false;
        }
        String this$individualBakDatabase = this.getIndividualBakDatabase();
        String other$individualBakDatabase = other.getIndividualBakDatabase();
        return !(this$individualBakDatabase == null ? other$individualBakDatabase != null : !this$individualBakDatabase.equals(other$individualBakDatabase));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MongodbConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $testDatabase = this.getTestDatabase();
        result = result * 59 + ($testDatabase == null ? 43 : $testDatabase.hashCode());
        String $masterDatabase = this.getMasterDatabase();
        result = result * 59 + ($masterDatabase == null ? 43 : $masterDatabase.hashCode());
        String $bakDatabase = this.getBakDatabase();
        result = result * 59 + ($bakDatabase == null ? 43 : $bakDatabase.hashCode());
        String $tenantDatabase = this.getTenantDatabase();
        result = result * 59 + ($tenantDatabase == null ? 43 : $tenantDatabase.hashCode());
        String $runtimeDatabase = this.getRuntimeDatabase();
        result = result * 59 + ($runtimeDatabase == null ? 43 : $runtimeDatabase.hashCode());
        String $individualDevDatabase = this.getIndividualDevDatabase();
        result = result * 59 + ($individualDevDatabase == null ? 43 : $individualDevDatabase.hashCode());
        String $individualTestDatabase = this.getIndividualTestDatabase();
        result = result * 59 + ($individualTestDatabase == null ? 43 : $individualTestDatabase.hashCode());
        String $individualMasterDatabase = this.getIndividualMasterDatabase();
        result = result * 59 + ($individualMasterDatabase == null ? 43 : $individualMasterDatabase.hashCode());
        String $individualBakDatabase = this.getIndividualBakDatabase();
        result = result * 59 + ($individualBakDatabase == null ? 43 : $individualBakDatabase.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MongodbConfig(uri=" + this.getUri() + ", database=" + this.getDatabase() + ", testDatabase=" + this.getTestDatabase() + ", masterDatabase=" + this.getMasterDatabase() + ", bakDatabase=" + this.getBakDatabase() + ", tenantDatabase=" + this.getTenantDatabase() + ", runtimeDatabase=" + this.getRuntimeDatabase() + ", individualDevDatabase=" + this.getIndividualDevDatabase() + ", individualTestDatabase=" + this.getIndividualTestDatabase() + ", individualMasterDatabase=" + this.getIndividualMasterDatabase() + ", individualBakDatabase=" + this.getIndividualBakDatabase() + ")";
    }
}

