/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.mongodb.repository;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.config.mongodb.MongodbConfig;
import com.digiwin.athena.mongodb.repository.MongoRepository;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.lang.annotation.Annotation;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public abstract class MongoUserRepositoryDecorator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MongoUserRepositoryDecorator.class);
    @Autowired
    private MongodbConfig mongodbConfig;
    @Autowired
    @Qualifier(value="mongoDynamicRepository")
    private MongoRepository mongoRepository;
    private static final SecureRandom random = new SecureRandom();
    private static final String TARGET_PACKAGE = "com.digiwin.athena.mongodb.domain.";

    abstract Map<String, String> getBranchDBNameMap();

    abstract String getBranchName();

    public String getDBName() {
        Map<String, String> branchDBNameMap = this.getBranchDBNameMap();
        String branchName = this.getBranchName();
        String dbName = branchDBNameMap.get(branchName);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dbName), (String)"The current branch does not have database", (Object[])new Object[0]);
        return dbName;
    }

    protected String getWDBName() {
        return this.getDBName();
    }

    public <T> UpdateResult upsert(Query query2, Update update, String collection) {
        String DBName = this.getWDBName();
        this.preOperateProcess(update, false);
        return this.mongoRepository.upsert(DBName, query2, update, collection);
    }

    public <T> long updateMulti(Query query2, Update update, Class<T> tClass) {
        String DBName = this.getDBName();
        this.preOperateProcess(update, false);
        return this.mongoRepository.updateMulti(DBName, tClass, query2, update);
    }

    public <T> UpdateResult upsert(Query query2, Update update, String collection, String application) {
        String DBName = this.getWDBName();
        this.preOperateProcess(update, false);
        return this.mongoRepository.upsert(DBName, query2, update, collection);
    }

    public <T> UpdateResult upsert(Query query2, T t, Class<T> clazz) {
        String json = JSON.toJSONString(t);
        JSONObject jsonObject = JSON.parseObject((String)json);
        Update update = new Update();
        jsonObject.forEach((k, v) -> {
            if ("createTime".equals(k)) {
                if (v instanceof Long) {
                    update.set(k, (Object)DateUtil.date((long)Convert.toLong((Object)v)));
                } else if (v instanceof String && !NumberUtil.isNumber((CharSequence)String.valueOf(v))) {
                    update.set(k, (Object)DateUtil.parse((CharSequence)String.valueOf(v), (String)"yyyy-MM-dd HH:mm:ss"));
                } else {
                    update.set(k, (Object)DateUtil.date((long)Convert.toLong((Object)v)));
                }
            } else {
                update.set(k, v);
            }
        });
        update.set("updateTime", (Object)new Date());
        String collectionName = this.getCollectionNameFromDocumentAnnotedClass(clazz);
        String DBName = this.getWDBName();
        this.preOperateProcess(update, false);
        return this.mongoRepository.upsert(DBName, query2, update, collectionName);
    }

    public <T> UpdateResult upsertAgileData(Query query2, T t, Class<T> clazz) {
        String json = JSON.toJSONString(t);
        JSONObject jsonObject = JSON.parseObject((String)json);
        Update update = new Update();
        jsonObject.forEach((k, v) -> {
            if ("createTime".equals(k)) {
                if (v instanceof Long) {
                    update.set(k, (Object)DateUtil.date((long)Convert.toLong((Object)v)));
                } else if (v instanceof String && !NumberUtil.isNumber((CharSequence)String.valueOf(v))) {
                    update.set(k, (Object)DateUtil.parse((CharSequence)String.valueOf(v), (String)"yyyy-MM-dd HH:mm:ss"));
                } else {
                    update.set(k, (Object)DateUtil.date((long)Convert.toLong((Object)v)));
                }
            } else {
                update.set(k, v);
            }
        });
        update.set("updateTime", (Object)new Date());
        String collectionName = this.getCollectionNameFromDocumentAnnotedClass(clazz);
        String DBName = this.getWDBName();
        this.preOperateProcess(update, false);
        return this.mongoRepository.upsert(DBName, query2, update, collectionName);
    }

    public <T> String getCollectionNameFromDocumentAnnotedClass(Class clazz) {
        Document document = clazz.getAnnotation(Document.class);
        String collectionName = StringUtils.isEmpty((CharSequence)document.value()) ? document.collection() : document.value();
        collectionName = StringUtils.isEmpty((CharSequence)collectionName) ? clazz.getSimpleName().substring(0, 1).toLowerCase() + clazz.getSimpleName().substring(1) : collectionName;
        return collectionName;
    }

    private <T> String getCollectionNameFromDocumentAnnotedObj(T t) {
        Class<?> clazz = t.getClass();
        return this.getCollectionNameFromDocumentAnnotedClass(clazz);
    }

    private <T> String getApplication(T t, String collectionName) {
        return "";
    }

    public <T> T insert(T t) {
        String DBName = this.getWDBName();
        this.preOperateProcess(t, true);
        return this.mongoRepository.insert(DBName, t);
    }

    public <T> T insertNotEdit(T t) {
        String DBName = this.getWDBName();
        return this.mongoRepository.insert(DBName, t);
    }

    public <T> T insertNotEditAgileData(T t) {
        String collectionName = this.getCollectionNameFromDocumentAnnotedObj(t);
        String application = this.getApplication(t, collectionName);
        String DBName = this.getWDBName();
        return this.mongoRepository.insert(DBName, t);
    }

    public <T> T insert(String collectionName, T t) {
        String DBName = this.getWDBName();
        this.preOperateProcess(t, true);
        return this.mongoRepository.insert(DBName, collectionName, t);
    }

    public <T> T save(T t) {
        String DBName = this.getWDBName();
        this.preOperateProcess(t, false);
        return this.mongoRepository.save(DBName, t);
    }

    public <T> T saveAgileData(T t) {
        String DBName = this.getWDBName();
        this.preOperateProcess(t, false);
        return this.mongoRepository.save(DBName, t);
    }

    public <T> T saveEntity(T t) {
        String DBName = this.getWDBName();
        return this.mongoRepository.save(DBName, t);
    }

    public <T> T saveNotSetEditAgileData(T t) {
        String collectionName = this.getCollectionNameFromDocumentAnnotedObj(t);
        String application = this.getApplication(t, collectionName);
        String DBName = this.getWDBName();
        return this.mongoRepository.save(DBName, t);
    }

    public <T> T saveNotSetEdit(T t) {
        String DBName = this.getWDBName();
        return this.mongoRepository.save(DBName, t);
    }

    public <T> T save(String collectionName, T t) {
        String DBName = this.getWDBName();
        this.preOperateProcess(t, false);
        return this.mongoRepository.save(DBName, collectionName, t);
    }

    public <T> T save(String collectionName, T t, String application) {
        String DBName = this.getWDBName();
        this.preOperateProcess(t, false);
        return this.mongoRepository.save(DBName, collectionName, t);
    }

    public <T> void insertAll(Class<T> tClass, List<T> tList) {
        String DBName = this.getWDBName();
        tList.forEach(t -> this.preOperateProcess(t, true));
        this.mongoRepository.insertAll(DBName, tClass, tList);
    }

    public <T> void insertAll(String collectionName, List<T> tList) {
        String DBName = this.getWDBName();
        tList.forEach(t -> this.preOperateProcess(t, true));
        this.mongoRepository.insertAll(DBName, collectionName, tList);
    }

    public <T> DeleteResult delete(T obj) {
        String DBName = this.getWDBName();
        return this.mongoRepository.delete(DBName, obj);
    }

    public <T> DeleteResult delete(T obj, String collectionName) {
        String DBName = this.getWDBName();
        return this.mongoRepository.delete(DBName, obj, collectionName);
    }

    public <T> long remove(Query query2, String collectionName, Class<T> tClass) {
        String DBName = this.getWDBName();
        return this.mongoRepository.remove(DBName, tClass, query2);
    }

    public <T> DeleteResult delete(Query query2, Class<T> tClass) {
        String DBName = this.getWDBName();
        return this.mongoRepository.delete(DBName, tClass, query2);
    }

    public <T> DeleteResult deleteAgileData(Query query2, Class<T> tClass) {
        String collectionName = this.getCollectionNameFromDocumentAnnotedClass(tClass);
        List<T> tList = this.find(query2, tClass);
        if (CollectionUtils.isEmpty(tList)) {
            return new DeleteResult(){

                public boolean wasAcknowledged() {
                    return false;
                }

                public long getDeletedCount() {
                    return 0L;
                }
            };
        }
        String application = this.getApplication(tList.get(0), collectionName);
        String DBName = this.getWDBName();
        return this.mongoRepository.delete(DBName, tClass, query2);
    }

    public <T> long remove(Query query2, Class<T> tClass) {
        String DBName = this.getWDBName();
        return this.mongoRepository.remove(DBName, tClass, query2);
    }

    public <T> long removeAgileData(Query query2, Class<T> tClass) {
        String DBName = this.getWDBName();
        return this.mongoRepository.remove(DBName, tClass, query2);
    }

    public <T> long remove(Query query2, String application, String collectionName) {
        String DBName = this.getWDBName();
        return this.mongoRepository.remove(DBName, collectionName, query2);
    }

    public <T> UpdateResult updateFirst(Query query2, Update update, Class<T> tClass) {
        String collectionName = this.getCollectionNameFromDocumentAnnotedClass(tClass);
        Assert.notBlank((CharSequence)collectionName, (String)"Collection name cannot be empty", (Object[])new Object[0]);
        String DBName = this.getDBName();
        this.preOperateProcess(update, false);
        return this.mongoRepository.updateFirst(DBName, tClass, query2, update);
    }

    public <T> UpdateResult updateAgileFirst(Query query2, Update update, Class<T> tClass) {
        String collectionName = this.getCollectionNameFromDocumentAnnotedClass(tClass);
        Assert.notBlank((CharSequence)collectionName, (String)"Collection name cannot be empty", (Object[])new Object[0]);
        String DBName = this.getDBName();
        this.preOperateProcess(update, false);
        return this.mongoRepository.updateFirst(DBName, tClass, query2, update);
    }

    public <T> UpdateResult updateFirst(Query query2, Update update, String collectionName) {
        String DBName = this.getDBName();
        this.preOperateProcess(update, false);
        return this.mongoRepository.updateFirst(DBName, collectionName, query2, update);
    }

    public <T> List<T> find(Query query2, Class<T> tClass) {
        String DBName = this.getDBName();
        return this.mongoRepository.find(DBName, tClass, query2);
    }

    public <T> List<T> find(String collectionName, Query query2, Class<T> tClass) {
        String DBName = this.getDBName();
        return this.mongoRepository.find(DBName, collectionName, query2, tClass);
    }

    public <T> List<T> findAll(Class<T> tClass) {
        String DBName = this.getDBName();
        return this.mongoRepository.findAll(DBName, tClass);
    }

    public <T> T findOne(Query query2, Class<T> tClass) {
        String DBName = this.getDBName();
        return this.mongoRepository.findOne(DBName, tClass, query2);
    }

    public <T> T findOne(Query query2, String collectionName, Class<T> tClass) {
        String DBName = this.getDBName();
        return this.mongoRepository.findOne(DBName, tClass, collectionName, query2);
    }

    public long count(Query query2, @Nullable Class<?> entityClass) {
        String DBName = this.getDBName();
        return this.mongoRepository.count(DBName, query2, entityClass);
    }

    public <T> Page<T> findWithPage(Pageable pageable, Query query2, Class<T> tClass) {
        String DBName = this.getDBName();
        return this.mongoRepository.findWithPage(DBName, pageable, tClass, query2);
    }

    public <T> List<T> findByBranch(String branchName, Query query2, Class<T> tClass) {
        String simpleName = this.mongodbConfig.getBranchDBNameMap().get(branchName);
        if (StringUtils.isBlank((CharSequence)simpleName)) {
            log.error("branch \u4e0d\u5b58\u5728:{}", (Object)branchName);
            throw new BusinessException("Branch does not exist");
        }
        return this.mongoRepository.find(simpleName, tClass, query2);
    }

    public <T> List<T> findByDBName(String DBName, Query query2, Class<T> tClass) {
        return this.mongoRepository.find(DBName, tClass, query2);
    }

    public <T> T saveByDBName(String DBName, T t) {
        this.preOperateProcess(t, false);
        return this.mongoRepository.save(DBName, t);
    }

    public <T> long removeByDBName(String DBName, Query query2, Class<T> tClass) {
        List<T> tList = this.findByDBName(DBName, query2, tClass);
        if (CollectionUtils.isEmpty(tList)) {
            return 0L;
        }
        return this.mongoRepository.remove(DBName, tClass, query2);
    }

    public void removeByCollection(List<String> branchNames, String collection, Query query2) {
        branchNames.forEach(branchName -> {
            String simpleName = this.mongodbConfig.getBranchDBNameMap().get(branchName);
            if (StringUtils.isBlank((CharSequence)simpleName)) {
                log.error("branch \u4e0d\u5b58\u5728:{}", branchName);
                throw new BusinessException("Branch does not exist");
            }
            this.mongoRepository.remove(simpleName, collection, query2);
        });
    }

    public void removeByBranch(String branchName, String collection, Query query2) {
        String simpleName = this.mongodbConfig.getBranchDBNameMap().get(branchName);
        if (StringUtils.isBlank((CharSequence)simpleName)) {
            log.error("branch \u4e0d\u5b58\u5728:{}", (Object)branchName);
            throw new BusinessException("Branch does not exist");
        }
        this.mongoRepository.remove(simpleName, collection, query2);
    }

    private <T> void preOperateProcess(T obj, boolean isInsert) {
    }

    private String generateRandomClassName(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char randomChar = i == 0 ? (char)(65 + random.nextInt(26)) : (char)(97 + random.nextInt(26));
            sb.append(randomChar);
        }
        return sb.toString();
    }

    private <T> String getTargetCollection(T obj) {
        String collectionName = null;
        Class<?> objClass = obj.getClass();
        Annotation[] annotations = objClass.getAnnotations();
        if (annotations.length > 0) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof Document)) continue;
                Document document = (Document)annotation;
                collectionName = document.value();
                break;
            }
        }
        if (StringUtils.isEmpty(collectionName)) {
            String name = objClass.getName();
            if (name.contains(".")) {
                String[] parts = name.split("\\.");
                collectionName = this.firstLetterToLowerCase(parts[parts.length - 1]);
            } else {
                collectionName = this.firstLetterToLowerCase(name);
            }
        }
        return collectionName;
    }

    private String firstLetterToLowerCase(String input) {
        if (StringUtils.isEmpty((CharSequence)input)) {
            return input;
        }
        return input.substring(0, 1).toLowerCase() + input.substring(1);
    }

    public <T> T findById(Object id, Class<T> entityClass) {
        String DBName = this.getDBName();
        return this.mongoRepository.findById(DBName, id, entityClass);
    }

    public <T> Collection<T> insertAll(Collection<? extends T> collection) {
        String DBName = this.getDBName();
        return this.mongoRepository.insertAll(DBName, collection);
    }

    public <T> Collection<T> insertAllAgileData(Collection<? extends T> collection) {
        String DBName = this.getDBName();
        return this.mongoRepository.insertAll(DBName, collection);
    }

    public <T> T findOne(Query query2, Class<T> entityClass, String collectionName) {
        String DBName = this.getDBName();
        return this.mongoRepository.findOne(DBName, query2, entityClass, collectionName);
    }

    public <T> List<T> find(Query query2, Class<T> entityClass, String collectionName) {
        String DBName = this.getDBName();
        return this.mongoRepository.find(DBName, query2, entityClass, collectionName);
    }

    public DeleteResult remove(Query query2, String collectionName) {
        String DBName = this.getDBName();
        return this.mongoRepository.remove(DBName, query2, collectionName);
    }

    public <T> T save(T objectToSave, String collectionName) {
        String DBName = this.getDBName();
        return this.mongoRepository.save(DBName, objectToSave, collectionName);
    }

    public long count(Query query2, @Nullable Class<?> entityClass, String collectionName) {
        String DBName = this.getDBName();
        return this.mongoRepository.count(DBName, query2, entityClass, collectionName);
    }

    public <T> Collection<T> insert(Collection<? extends T> batchToSave, Class<?> entityClass) {
        String DBName = this.getDBName();
        return this.mongoRepository.insert(DBName, batchToSave, entityClass);
    }

    public <T> T insert(T objectToSave, String collectionName) {
        String DBName = this.getDBName();
        return this.mongoRepository.insert(DBName, objectToSave, collectionName);
    }

    public MongoDatabaseFactory getMongoDbFactory() {
        String DBName = this.getDBName();
        return this.mongoRepository.getMongoDbFactory(DBName);
    }

    public <T> List<T> findAllAndRemove(Query query2, Class<T> entityClass, String collectionName) {
        String DBName = this.getDBName();
        return this.mongoRepository.findAllAndRemove(DBName, query2, entityClass, collectionName);
    }

    public boolean exists(Query query2, @Nullable Class<?> entityClass, String collectionName) {
        String DBName = this.getDBName();
        return this.mongoRepository.exists(DBName, query2, entityClass, collectionName);
    }

    public <O> AggregationResults<O> aggregate(Aggregation aggregation, Class<?> inputType, Class<O> outputType) {
        String DBName = this.getDBName();
        return this.mongoRepository.aggregate(DBName, aggregation, inputType, outputType);
    }

    public <O> AggregationResults<O> aggregate(TypedAggregation<?> aggregation, Class<O> outputType) {
        String DBName = this.getDBName();
        return this.mongoRepository.aggregate(DBName, aggregation, outputType);
    }

    public <O> AggregationResults<O> aggregate(Aggregation aggregation, String collectionName, Class<O> outputType) {
        String DBName = this.getDBName();
        return this.mongoRepository.aggregate(DBName, aggregation, collectionName, outputType);
    }

    public BulkOperations bulkOps(BulkOperations.BulkMode mode, Class<?> entityType) {
        String DBName = this.getDBName();
        return this.mongoRepository.bulkOps(DBName, mode, entityType);
    }

    public Set<String> getCollectionNames() {
        String dBName = this.getDBName();
        return this.mongoRepository.getCollectionNames(dBName);
    }

    public <T> T insertWithOutEdit(T t) {
        String DBName = this.getWDBName();
        return this.mongoRepository.insert(DBName, t);
    }

    public MongoTemplate getTargetMongoTemplate() {
        String dBName = this.getDBName();
        return this.mongoRepository.getTargetMongoTemplate(dBName);
    }
}

