/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dto;

import com.digiwin.athena.dto.PageReqCondition;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import lombok.Generated;

public class Pagination<T> {
    @Schema(description="\u5f53\u524d\u9875\u6570")
    private Integer curPageNum;
    @Schema(description="\u603b\u9875\u6570")
    private Integer totalPageNum;
    @Schema(description="\u6bcf\u9875\u6761\u6570")
    private Integer limit;
    @Schema(description="\u603b\u6761\u6570")
    private Long total;
    private List<T> data;

    public static <T> Pagination<T> buildPagination(PageReqCondition pageReqCondition, List<T> records, Long count) {
        Pagination<T> res = new Pagination<T>();
        res.setData(records);
        res.setTotal(count);
        res.setCurPageNum(pageReqCondition.getPageNum());
        res.setTotalPageNum(count.intValue() / pageReqCondition.getPageSize() + 1);
        res.setLimit(pageReqCondition.getPageSize());
        return res;
    }

    @Generated
    public static <T> PaginationBuilder<T> builder() {
        return new PaginationBuilder();
    }

    @Generated
    public Integer getCurPageNum() {
        return this.curPageNum;
    }

    @Generated
    public Integer getTotalPageNum() {
        return this.totalPageNum;
    }

    @Generated
    public Integer getLimit() {
        return this.limit;
    }

    @Generated
    public Long getTotal() {
        return this.total;
    }

    @Generated
    public List<T> getData() {
        return this.data;
    }

    @Generated
    public void setCurPageNum(Integer curPageNum) {
        this.curPageNum = curPageNum;
    }

    @Generated
    public void setTotalPageNum(Integer totalPageNum) {
        this.totalPageNum = totalPageNum;
    }

    @Generated
    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    @Generated
    public void setTotal(Long total) {
        this.total = total;
    }

    @Generated
    public void setData(List<T> data) {
        this.data = data;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pagination)) {
            return false;
        }
        Pagination other = (Pagination)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$curPageNum = this.getCurPageNum();
        Integer other$curPageNum = other.getCurPageNum();
        if (this$curPageNum == null ? other$curPageNum != null : !((Object)this$curPageNum).equals(other$curPageNum)) {
            return false;
        }
        Integer this$totalPageNum = this.getTotalPageNum();
        Integer other$totalPageNum = other.getTotalPageNum();
        if (this$totalPageNum == null ? other$totalPageNum != null : !((Object)this$totalPageNum).equals(other$totalPageNum)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Long this$total = this.getTotal();
        Long other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        List<T> this$data = this.getData();
        List<T> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Pagination;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $curPageNum = this.getCurPageNum();
        result = result * 59 + ($curPageNum == null ? 43 : ((Object)$curPageNum).hashCode());
        Integer $totalPageNum = this.getTotalPageNum();
        result = result * 59 + ($totalPageNum == null ? 43 : ((Object)$totalPageNum).hashCode());
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Long $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        List<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Pagination(curPageNum=" + this.getCurPageNum() + ", totalPageNum=" + this.getTotalPageNum() + ", limit=" + this.getLimit() + ", total=" + this.getTotal() + ", data=" + this.getData() + ")";
    }

    @Generated
    public Pagination(Integer curPageNum, Integer totalPageNum, Integer limit, Long total, List<T> data) {
        this.curPageNum = curPageNum;
        this.totalPageNum = totalPageNum;
        this.limit = limit;
        this.total = total;
        this.data = data;
    }

    @Generated
    public Pagination() {
    }

    @Generated
    public static class PaginationBuilder<T> {
        @Generated
        private Integer curPageNum;
        @Generated
        private Integer totalPageNum;
        @Generated
        private Integer limit;
        @Generated
        private Long total;
        @Generated
        private List<T> data;

        @Generated
        PaginationBuilder() {
        }

        @Generated
        public PaginationBuilder<T> curPageNum(Integer curPageNum) {
            this.curPageNum = curPageNum;
            return this;
        }

        @Generated
        public PaginationBuilder<T> totalPageNum(Integer totalPageNum) {
            this.totalPageNum = totalPageNum;
            return this;
        }

        @Generated
        public PaginationBuilder<T> limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Generated
        public PaginationBuilder<T> total(Long total) {
            this.total = total;
            return this;
        }

        @Generated
        public PaginationBuilder<T> data(List<T> data) {
            this.data = data;
            return this;
        }

        @Generated
        public Pagination<T> build() {
            return new Pagination<T>(this.curPageNum, this.totalPageNum, this.limit, this.total, this.data);
        }

        @Generated
        public String toString() {
            return "Pagination.PaginationBuilder(curPageNum=" + this.curPageNum + ", totalPageNum=" + this.totalPageNum + ", limit=" + this.limit + ", total=" + this.total + ", data=" + this.data + ")";
        }
    }
}

