package com.digiwin.athena.config.http;

import cn.hutool.http.GlobalInterceptor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class HutoolHttpConfig implements ApplicationRunner {

    @Value("${rest-url.appToken}")
    private String appToken;

    @Override
    public void run(ApplicationArguments args) throws Exception {
        GlobalInterceptor.INSTANCE.addRequestInterceptor(new HutoolRouterKeyInterceptor(appToken))
                .addRequestInterceptor(new HutoolLogRequestInterceptor())
                .addResponseInterceptor(new HutoolLogResponseInterceptor());
    }
}
