/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.config;

import com.digiwin.athena.config.mongodb.MongodbConfig;
import com.digiwin.athena.mysql.domain.archive.CollectionPKPO;
import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BranchConfig {
    private MongodbConfig mongodbConfig;
    public static String DEV_BRANCH_NAME_DATABASE;
    public static String MASTER_BRANCH_NAME_DATABASE;
    public static String TEST_BRANCH_NAME_DATABASE;
    public static String BAK_BRANCH_NAME_DATABASE;
    public static String SYS_BRANCH_NAME_DATABASE;
    public static final String RUNTIME_BRANCH_NAME = "runtime";
    public static Map<String, String> BRANCH_DB_MAP;
    public static final Map<String, String> INDIVIDUAL_BRANCH_DB_MAP;
    public static final Map<String, String> BRANCH_NAME_MAP;
    private final String ssoTokenPrefix = "ADP_SSO_TOKEN_PREFIX_";
    private final String ssoCurrentBranch = "ADP_SSO_CURRENT_BRANCH_";
    private final String workDir = "/usr/local/athenadesigner";
    public static final String DEV_BRANCH_NAME = "develop";
    public static final String TEST_BRANCH_NAME = "test";
    public static final String MASTER_BRANCH_NAME = "master";
    public static final String BAK_BRANCH_NAME = "bak";
    public static final String TENANT_BRANCH_NAME = "tenant";
    private List<CollectionPKPO> extraCollectionPKPOs;
    private List<CollectionPKPO> noAppCodeCollectionPKPOs;
    public static final Map<String, List<String>> BRANCH_CREATE_MAP;
    public static final Map<String, String> MODEL_DB_MAP_4_PAGE_DESIGN;
    private List<String> extraCollectionNames = Arrays.asList("applicationExample", "applicationInstallRecord", "backupData", "compiledData", "compileVersion", "favourite", "projectDetail", "taskDetail", "transferError", "gptUploadLog", "gptSessionInfo");
    private List<String> pageDesignMigrationCollectionNames = Arrays.asList("pageDesign", "neo4jActivity", "applicationRelation", "pageDesignModelDslRelation", "businessDir", "rules", "activityConfigs", "adTag", "taskRelation", "pageUIElement");

    @Autowired
    public void setMongodbConfig(MongodbConfig mongodbConfig) {
        this.mongodbConfig = mongodbConfig;
    }

    @PostConstruct
    public void init() {
        BRANCH_NAME_MAP.put(DEV_BRANCH_NAME, "\u5f00\u53d1\u5206\u652f");
        BRANCH_NAME_MAP.put(TEST_BRANCH_NAME, "\u6d4b\u8bd5\u5206\u652f");
        BRANCH_NAME_MAP.put(MASTER_BRANCH_NAME, "\u6b63\u5f0f\u5206\u652f");
        BRANCH_NAME_MAP.put(BAK_BRANCH_NAME, "\u5907\u4efd\u5206\u652f");
        String masterDBName = this.mongodbConfig.getMasterDatabase();
        SYS_BRANCH_NAME_DATABASE = this.mongodbConfig.getMasterDatabase();
        BAK_BRANCH_NAME_DATABASE = this.mongodbConfig.getBakDatabase();
        TEST_BRANCH_NAME_DATABASE = this.mongodbConfig.getTestDatabase();
        MASTER_BRANCH_NAME_DATABASE = this.mongodbConfig.getMasterDatabase();
        DEV_BRANCH_NAME_DATABASE = this.mongodbConfig.getDatabase();
        BRANCH_DB_MAP.put(TEST_BRANCH_NAME, this.mongodbConfig.getTestDatabase());
        BRANCH_DB_MAP.put(MASTER_BRANCH_NAME, this.mongodbConfig.getMasterDatabase());
        BRANCH_DB_MAP.put(BAK_BRANCH_NAME, this.mongodbConfig.getBakDatabase());
        INDIVIDUAL_BRANCH_DB_MAP.put(TEST_BRANCH_NAME, this.mongodbConfig.getIndividualTestDatabase());
        INDIVIDUAL_BRANCH_DB_MAP.put(MASTER_BRANCH_NAME, this.mongodbConfig.getIndividualMasterDatabase());
        INDIVIDUAL_BRANCH_DB_MAP.put(BAK_BRANCH_NAME, this.mongodbConfig.getIndividualBakDatabase());
        this.extraCollectionPKPOs = Arrays.asList(new CollectionPKPO(masterDBName, "applicationExample", "application", "com.digiwin.athena.mongodb.domain.application.ApplicationExample"), new CollectionPKPO(masterDBName, "applicationInstallRecord", "application", "com.digiwin.athena.mongodb.domain.application.ApplicationInstallRecord"), new CollectionPKPO(masterDBName, "compileVersion", "application", "com.digiwin.athena.domain.compile.CompileVersion"), new CollectionPKPO(masterDBName, "favourite", "application", "com.digiwin.athena.mongodb.domain.favourite.Favourite"), new CollectionPKPO(masterDBName, "projectDetail", "application", "com.digiwin.athena.domain.pageview.design.projectdetail.ProjectDetail"), new CollectionPKPO(masterDBName, "taskDetail", "application", "com.digiwin.athena.domain.pageview.design.taskdetail.TaskDetail"), new CollectionPKPO(masterDBName, "transferError", "application", "com.digiwin.athena.mongodb.domain.transfer.TransferError"), new CollectionPKPO(masterDBName, "gptUploadLog", "appCode", "com.digiwin.athena.mongodb.domain.ai.GPTUploadLog"), new CollectionPKPO(masterDBName, "gptSessionInfo", "appCode", "com.digiwin.athena.mongodb.domain.ai.GPTSessionInfo"));
        this.noAppCodeCollectionPKPOs = Arrays.asList(new CollectionPKPO(masterDBName, "presetData", "", "com.digiwin.athena.mongodb.domain.other.PresetData"), new CollectionPKPO(masterDBName, "mechanismPartDoc", "", "com.digiwin.athena.mechanism.pre.MechanismPartDoc"), new CollectionPKPO(masterDBName, "applicationParamConfig", "", "com.digiwin.athena.mongodb.domain.application.ApplicationParamConfig"), new CollectionPKPO(masterDBName, "applicationParamRelation", "", "com.digiwin.athena.mongodb.domain.application.ApplicationParamRelation"), new CollectionPKPO(masterDBName, "dataMap", "", "com.digiwin.athena.mongodb.domain.data.DataMap"), new CollectionPKPO(masterDBName, "espAsyncData", "", "com.digiwin.athena.mongodb.domain.other.EspAsyncData"), new CollectionPKPO(masterDBName, "product", "", "com.digiwin.athena.mongodb.domain.task.Product"));
    }

    @Generated
    public BranchConfig() {
    }

    @Generated
    public MongodbConfig getMongodbConfig() {
        return this.mongodbConfig;
    }

    @Generated
    public String getSsoTokenPrefix() {
        return this.ssoTokenPrefix;
    }

    @Generated
    public String getSsoCurrentBranch() {
        return this.ssoCurrentBranch;
    }

    @Generated
    public String getWorkDir() {
        return this.workDir;
    }

    @Generated
    public List<CollectionPKPO> getExtraCollectionPKPOs() {
        return this.extraCollectionPKPOs;
    }

    @Generated
    public List<CollectionPKPO> getNoAppCodeCollectionPKPOs() {
        return this.noAppCodeCollectionPKPOs;
    }

    @Generated
    public List<String> getExtraCollectionNames() {
        return this.extraCollectionNames;
    }

    @Generated
    public List<String> getPageDesignMigrationCollectionNames() {
        return this.pageDesignMigrationCollectionNames;
    }

    @Generated
    public void setExtraCollectionPKPOs(List<CollectionPKPO> extraCollectionPKPOs) {
        this.extraCollectionPKPOs = extraCollectionPKPOs;
    }

    @Generated
    public void setNoAppCodeCollectionPKPOs(List<CollectionPKPO> noAppCodeCollectionPKPOs) {
        this.noAppCodeCollectionPKPOs = noAppCodeCollectionPKPOs;
    }

    @Generated
    public void setExtraCollectionNames(List<String> extraCollectionNames) {
        this.extraCollectionNames = extraCollectionNames;
    }

    @Generated
    public void setPageDesignMigrationCollectionNames(List<String> pageDesignMigrationCollectionNames) {
        this.pageDesignMigrationCollectionNames = pageDesignMigrationCollectionNames;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BranchConfig)) {
            return false;
        }
        BranchConfig other = (BranchConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MongodbConfig this$mongodbConfig = this.getMongodbConfig();
        MongodbConfig other$mongodbConfig = other.getMongodbConfig();
        if (this$mongodbConfig == null ? other$mongodbConfig != null : !((Object)((Object)this$mongodbConfig)).equals((Object)other$mongodbConfig)) {
            return false;
        }
        String this$ssoTokenPrefix = this.getSsoTokenPrefix();
        String other$ssoTokenPrefix = other.getSsoTokenPrefix();
        if (this$ssoTokenPrefix == null ? other$ssoTokenPrefix != null : !this$ssoTokenPrefix.equals(other$ssoTokenPrefix)) {
            return false;
        }
        String this$ssoCurrentBranch = this.getSsoCurrentBranch();
        String other$ssoCurrentBranch = other.getSsoCurrentBranch();
        if (this$ssoCurrentBranch == null ? other$ssoCurrentBranch != null : !this$ssoCurrentBranch.equals(other$ssoCurrentBranch)) {
            return false;
        }
        String this$workDir = this.getWorkDir();
        String other$workDir = other.getWorkDir();
        if (this$workDir == null ? other$workDir != null : !this$workDir.equals(other$workDir)) {
            return false;
        }
        List<CollectionPKPO> this$extraCollectionPKPOs = this.getExtraCollectionPKPOs();
        List<CollectionPKPO> other$extraCollectionPKPOs = other.getExtraCollectionPKPOs();
        if (this$extraCollectionPKPOs == null ? other$extraCollectionPKPOs != null : !((Object)this$extraCollectionPKPOs).equals(other$extraCollectionPKPOs)) {
            return false;
        }
        List<CollectionPKPO> this$noAppCodeCollectionPKPOs = this.getNoAppCodeCollectionPKPOs();
        List<CollectionPKPO> other$noAppCodeCollectionPKPOs = other.getNoAppCodeCollectionPKPOs();
        if (this$noAppCodeCollectionPKPOs == null ? other$noAppCodeCollectionPKPOs != null : !((Object)this$noAppCodeCollectionPKPOs).equals(other$noAppCodeCollectionPKPOs)) {
            return false;
        }
        List<String> this$extraCollectionNames = this.getExtraCollectionNames();
        List<String> other$extraCollectionNames = other.getExtraCollectionNames();
        if (this$extraCollectionNames == null ? other$extraCollectionNames != null : !((Object)this$extraCollectionNames).equals(other$extraCollectionNames)) {
            return false;
        }
        List<String> this$pageDesignMigrationCollectionNames = this.getPageDesignMigrationCollectionNames();
        List<String> other$pageDesignMigrationCollectionNames = other.getPageDesignMigrationCollectionNames();
        return !(this$pageDesignMigrationCollectionNames == null ? other$pageDesignMigrationCollectionNames != null : !((Object)this$pageDesignMigrationCollectionNames).equals(other$pageDesignMigrationCollectionNames));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BranchConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MongodbConfig $mongodbConfig = this.getMongodbConfig();
        result = result * 59 + ($mongodbConfig == null ? 43 : ((Object)((Object)$mongodbConfig)).hashCode());
        String $ssoTokenPrefix = this.getSsoTokenPrefix();
        result = result * 59 + ($ssoTokenPrefix == null ? 43 : $ssoTokenPrefix.hashCode());
        String $ssoCurrentBranch = this.getSsoCurrentBranch();
        result = result * 59 + ($ssoCurrentBranch == null ? 43 : $ssoCurrentBranch.hashCode());
        String $workDir = this.getWorkDir();
        result = result * 59 + ($workDir == null ? 43 : $workDir.hashCode());
        List<CollectionPKPO> $extraCollectionPKPOs = this.getExtraCollectionPKPOs();
        result = result * 59 + ($extraCollectionPKPOs == null ? 43 : ((Object)$extraCollectionPKPOs).hashCode());
        List<CollectionPKPO> $noAppCodeCollectionPKPOs = this.getNoAppCodeCollectionPKPOs();
        result = result * 59 + ($noAppCodeCollectionPKPOs == null ? 43 : ((Object)$noAppCodeCollectionPKPOs).hashCode());
        List<String> $extraCollectionNames = this.getExtraCollectionNames();
        result = result * 59 + ($extraCollectionNames == null ? 43 : ((Object)$extraCollectionNames).hashCode());
        List<String> $pageDesignMigrationCollectionNames = this.getPageDesignMigrationCollectionNames();
        result = result * 59 + ($pageDesignMigrationCollectionNames == null ? 43 : ((Object)$pageDesignMigrationCollectionNames).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BranchConfig(mongodbConfig=" + this.getMongodbConfig() + ", ssoTokenPrefix=" + this.getSsoTokenPrefix() + ", ssoCurrentBranch=" + this.getSsoCurrentBranch() + ", workDir=" + this.getWorkDir() + ", extraCollectionPKPOs=" + this.getExtraCollectionPKPOs() + ", noAppCodeCollectionPKPOs=" + this.getNoAppCodeCollectionPKPOs() + ", extraCollectionNames=" + this.getExtraCollectionNames() + ", pageDesignMigrationCollectionNames=" + this.getPageDesignMigrationCollectionNames() + ")";
    }

    static {
        BRANCH_DB_MAP = new HashMap<String, String>();
        INDIVIDUAL_BRANCH_DB_MAP = new HashMap<String, String>();
        BRANCH_NAME_MAP = new HashMap<String, String>();
        BRANCH_CREATE_MAP = new HashMap<String, List<String>>();
        BRANCH_CREATE_MAP.put(DEV_BRANCH_NAME, Arrays.asList(TEST_BRANCH_NAME, BAK_BRANCH_NAME));
        BRANCH_CREATE_MAP.put(TEST_BRANCH_NAME, Arrays.asList(MASTER_BRANCH_NAME, BAK_BRANCH_NAME));
        BRANCH_CREATE_MAP.put(MASTER_BRANCH_NAME, Arrays.asList(BAK_BRANCH_NAME));
        MODEL_DB_MAP_4_PAGE_DESIGN = new HashMap<String, String>();
        MODEL_DB_MAP_4_PAGE_DESIGN.put("pageDesign", "pageDesign");
        MODEL_DB_MAP_4_PAGE_DESIGN.put("neo4jActivity", "neo4jActivity");
        MODEL_DB_MAP_4_PAGE_DESIGN.put("applicationRelation", "applicationRelation");
        MODEL_DB_MAP_4_PAGE_DESIGN.put("pageDesignModelDslRelation", "pageDesignModelDslRelation");
        MODEL_DB_MAP_4_PAGE_DESIGN.put("rule", "rules");
        MODEL_DB_MAP_4_PAGE_DESIGN.put("businessDirModel", "businessDir");
        MODEL_DB_MAP_4_PAGE_DESIGN.put("activityConfig", "activityConfigs");
        MODEL_DB_MAP_4_PAGE_DESIGN.put("adTag", "adTag");
        MODEL_DB_MAP_4_PAGE_DESIGN.put("taskRelation", "taskRelation");
        MODEL_DB_MAP_4_PAGE_DESIGN.put("pageUIElement", "pageUIElement");
    }
}

