package com.digiwin.athena.mongodb.repository;

import cn.hutool.core.lang.Assert;
import com.digiwin.athena.config.BranchConfig;
import com.digiwin.athena.config.mongodb.MongodbConfig;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.Map;

@Slf4j
@Repository("mongoUserRepositoryDecorator")
public class MongoMultiRepositoryDecorator extends MongoUserRepositoryDecorator{

    @Autowired
    private MongodbConfig mongodbConfig;
    private final static Map<String,String> BRANCH_DB_NAME_MAP= new HashMap<>();

    @Override
    Map<String,String> getBranchDBNameMap() {

        return mongodbConfig.getBranchDBNameMap();
    }

    @Override
    String getBranchName() {
        String branchKey = CurThreadInfoUtils.getBranchKey();
        if (StringUtils.isBlank(branchKey)){
            branchKey = BranchConfig.DEV_BRANCH_NAME;
        }
        Assert.isTrue(StringUtils.isNotBlank(branchKey),"No branch information");
        return branchKey;
    }
}
