package com.digiwin.athena.config.http;

import com.digiwin.athena.config.MyTrustManager;
import okhttp3.OkHttpClient;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeUnit;

@Configuration
public class RestTemplateConfig {

    @Bean(name = "httpsRestTemplate")
    public RestTemplate httpsRestTemplate() throws NoSuchAlgorithmException, KeyManagementException {
        X509TrustManager trustManager = new MyTrustManager();
//        SSLContext sslContext = SSLContext.getInstance("TLS");
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(null, new TrustManager[]{trustManager}, null);

        OkHttpClient client = new OkHttpClient.Builder()
                .hostnameVerifier((host, session) -> true)
                .sslSocketFactory(sslContext.getSocketFactory(), trustManager)
                .connectTimeout(3, TimeUnit.MINUTES)
                .readTimeout(3, TimeUnit.MINUTES)
                .writeTimeout(3, TimeUnit.MINUTES)
                .build();

        OkHttp3ClientHttpRequestFactory factory = new OkHttp3ClientHttpRequestFactory(client);
        return new RestTemplate(factory);
    }

    @Bean(name = "httpRestTemplate")
    public RestTemplate httpRestTemplate() {
        OkHttp3ClientHttpRequestFactory okHttp3ClientHttpRequestFactory = new OkHttp3ClientHttpRequestFactory();
        okHttp3ClientHttpRequestFactory.setConnectTimeout(1000*60*3);
        okHttp3ClientHttpRequestFactory.setReadTimeout(1000*60*3);
        okHttp3ClientHttpRequestFactory.setWriteTimeout(1000*60*3);
        RestTemplate restTemplate = new RestTemplate(okHttp3ClientHttpRequestFactory);
        restTemplate.getMessageConverters().stream().forEach(httpMessageConverter -> {
            if (httpMessageConverter instanceof StringHttpMessageConverter){
                ((StringHttpMessageConverter) httpMessageConverter).setDefaultCharset(Charset.forName("UTF-8"));
            }
        });
        restTemplate.setInterceptors(Arrays.asList(new RestTemplateLogInterceptor()));
        return restTemplate;
    }

    @Bean(name = "gptHttpRestTemplate")
    public RestTemplate gptHttpRestTemplate() throws NoSuchAlgorithmException, KeyManagementException {
        X509TrustManager trustManager = new MyTrustManager();
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(null, new TrustManager[]{trustManager}, null);

        OkHttpClient client = new OkHttpClient.Builder()
                .hostnameVerifier((host, session) -> true)
                .sslSocketFactory(sslContext.getSocketFactory(), trustManager)
                .connectTimeout(10, TimeUnit.MINUTES)
                .readTimeout(10, TimeUnit.MINUTES)
                .writeTimeout(10, TimeUnit.MINUTES)
                .build();

        OkHttp3ClientHttpRequestFactory factory = new OkHttp3ClientHttpRequestFactory(client);
        return new RestTemplate(factory);
    }

    @Bean(name = "iamRestTemplate")
    public RestTemplate iamRestTemplate(RestTemplateBuilder builder) {
        return builder.build();
    }

    @Bean(name = "gitLabRestTemplate")
    public RestTemplate gitLabRestTemplate(RestTemplateBuilder builder) {
        return builder.build();
    }

    @Bean(name = "dmcRestTemplate")
    public RestTemplate dmcRestTemplate(RestTemplateBuilder builder) {
        return builder.build();
    }

    @Bean
    public RestTemplate restTemplate(RestTemplateBuilder restTemplateBuilder, RestTemplateAddHeadersInterceptor restTemplateAddHeadersInterceptor) {
        // 这里使用RestTemplateBuilder来构建RestTemplate实例
        RestTemplate build = restTemplateBuilder.build();
        build.setInterceptors(Collections.singletonList(restTemplateAddHeadersInterceptor));
        return build;
    }

}
