/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.config.http;

import cn.hutool.http.HttpInterceptor;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONObject;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.digiwin.athena.base.BusinessException;
import java.lang.reflect.Field;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HutoolLogResponseInterceptor
implements HttpInterceptor<HttpResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HutoolLogResponseInterceptor.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(HttpResponse httpResponse) {
        int status = httpResponse.getStatus();
        String responseBody = httpResponse.body();
        log.info(String.format("hutoolLog status:%d,\u54cd\u5e94info:%s", httpResponse.getStatus(), httpResponse.toString()));
        if (httpResponse.isOk() || status == 401) return;
        Object httpConnection = this.getHttpConnection(httpResponse);
        if (httpConnection != null) {
            JSONObject connectionJson = new JSONObject(httpConnection);
            String url = connectionJson.getStr((Object)"url");
            if (url != null && url.endsWith("/api/iam/v2/identity/login")) {
                String message = this.extractMessageFromBody(responseBody);
                if (message == null) return;
                log.error("Login URL response error: {}", (Object)message);
                throw new BusinessException(String.format("hutoolLog \u54cd\u5e94\u5f02\u5e38, status: %d, \u9519\u8bef\u4fe1\u606f: %s", status, message));
            }
            log.error("Response body: {}", (Object)responseBody);
            throw new BusinessException(String.format("hutoolLog \u54cd\u5e94\u5f02\u5e38, status: %d, \u54cd\u5e94\u5185\u5bb9: %s", status, responseBody));
        }
        log.error("httpConnection \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5904\u7406\u54cd\u5e94.");
        throw new BusinessException("httpConnection \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5904\u7406\u54cd\u5e94.");
    }

    private Object getHttpConnection(HttpResponse httpResponse) {
        try {
            Field httpConnectionField = HttpResponse.class.getDeclaredField("httpConnection");
            httpConnectionField.setAccessible(true);
            return httpConnectionField.get(httpResponse);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            log.error("\u65e0\u6cd5\u8bbf\u95ee httpConnection \u5b57\u6bb5: {}", (Object)e.getMessage());
            return null;
        }
    }

    private String extractMessageFromBody(String body) {
        try {
            com.alibaba.fastjson.JSONObject jsonObject = JSON.parseObject((String)body);
            return jsonObject.getString("message");
        }
        catch (JSONException e) {
            log.error("\u89e3\u6790\u54cd\u5e94\u4f53\u65f6\u51fa\u9519: {}", (Object)e.getMessage());
            return null;
        }
    }
}

