/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.mongodb.repository;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.enums.VersionStatusEnum;
import com.digiwin.athena.mongodb.repository.MongoMultiRepositoryDecorator;
import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import com.digiwin.athena.mongodb.repository.MongoTenantRepositoryDecorator;
import com.digiwin.athena.mongodb.repository.MongoUserRepositoryDecorator;
import com.digiwin.athena.mongodb.repository.MultiVersionsCollection;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository(value="mongoMultiVersionsRepositoryDecorator")
public class MongoMultiVersionsRepositoryDecorator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MongoMultiVersionsRepositoryDecorator.class);
    public static final String HISTORY_SUFFIX = "History";
    @Autowired
    private MongoMultiRepositoryDecorator mongoMultiRepositoryDecorator;
    @Autowired
    private MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;
    @Autowired
    private MongoTenantRepositoryDecorator mongoTenantRepositoryDecorator;
    private static final Map<String, MultiVersionsCollection> VERSIONS_TABLE = new HashMap<String, MultiVersionsCollection>();

    private MongoUserRepositoryDecorator chooseRepository() {
        if (this.judgeTenantAdp().booleanValue()) {
            return this.mongoTenantRepositoryDecorator;
        }
        return this.mongoMultiRepositoryDecorator;
    }

    @PostConstruct
    public void init() {
        Criteria criteria = Criteria.where((String)"versionsFlag").is((Object)"Y");
        List<JSONObject> sysTableDefinitions = this.mongoSystemRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), JSONObject.class, "sys_tableDefinition");
        for (JSONObject tableDefinition : sysTableDefinitions) {
            MultiVersionsCollection sysMultiVersionsCollection = new MultiVersionsCollection();
            sysMultiVersionsCollection.setTableName(tableDefinition.getString("collection"));
            sysMultiVersionsCollection.setAdpRemark(tableDefinition.getString("adpRemark"));
            sysMultiVersionsCollection.setNeedUpdateAdpRemark("Y".equals(tableDefinition.getString("versionNeedUpdateAdpRemark")));
            sysMultiVersionsCollection.setPrimaryKey(tableDefinition.getString("versionsPrimaryKey"));
            VERSIONS_TABLE.put(tableDefinition.getString("collection"), sysMultiVersionsCollection);
        }
    }

    private String getCollectionName(Class clazz) {
        Document document = clazz.getAnnotation(Document.class);
        return StringUtils.isEmpty((CharSequence)document.value()) ? document.collection() : document.value();
    }

    private Boolean judgeVersionSync(String collectionName) {
        return !StringUtils.isBlank((CharSequence)CurThreadInfoUtils.getAdpVersion()) && VERSIONS_TABLE.containsKey(collectionName);
    }

    private Boolean judgeTenantAdp() {
        return !StringUtils.isBlank((CharSequence)CurThreadInfoUtils.getPlatformSource()) && "tenant".equals(CurThreadInfoUtils.getPlatformSource());
    }

    private Boolean hasOtherHeaderFlag() {
        return StringUtils.isNotBlank((CharSequence)CurThreadInfoUtils.getTemplateId());
    }

    private Boolean judgeKeyHasValue(Object obj) {
        try {
            for (Class<?> currentClass = obj.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
                for (Field field : currentClass.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(Id.class)) continue;
                    field.setAccessible(true);
                    Object value = field.get(obj);
                    if (value == null) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            log.error("\u5224\u65adid\u5b57\u6bb5\u662f\u5426\u6709\u503c\uff0c" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u5224\u65adid\u5b57\u6bb5\u662f\u5426\u6709\u503c\uff0c" + e.getMessage());
        }
        return false;
    }

    Object getHistoryPrimaryKeyValue(Object obj, String primaryKey) {
        try {
            for (Class<?> currentClass = obj.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
                for (Field field : currentClass.getDeclaredFields()) {
                    if (!field.getName().equals(primaryKey)) continue;
                    field.setAccessible(true);
                    Object value = field.get(obj);
                    return value;
                }
            }
            return null;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4e3b\u952e\u503c\u5931\u8d25\uff0c" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6\u4e3b\u952e\u503c\u5931\u8d25\uff0c" + e.getMessage());
        }
    }

    private void setAdpVersion(Object o, String adpVersion) {
        try {
            if (StringUtils.isNotBlank((CharSequence)adpVersion)) {
                Class<?> clazz = Class.forName(o.getClass().getName());
                Method setMethod = clazz.getMethod("setAdpVersion", String.class);
                setMethod.invoke(o, adpVersion);
            }
        }
        catch (Exception e) {
            log.error("setAdpVersion \u5931\u8d25\uff0c" + e.getMessage(), (Throwable)e);
        }
    }

    private void setTenantProcessId(Object o, String tenantProcessId) {
        try {
            if (StringUtils.isNotBlank((CharSequence)tenantProcessId)) {
                Class<?> clazz = Class.forName(o.getClass().getName());
                Method setMethod = clazz.getMethod("setTenantProcessId", String.class);
                setMethod.invoke(o, tenantProcessId);
            }
        }
        catch (Exception e) {
            log.error("setTenantProcessId \u5931\u8d25\uff0c" + e.getMessage(), (Throwable)e);
        }
    }

    private void setAdpRemark(Object o, Object adpRemark) {
        try {
            Class<?> clazz = Class.forName(o.getClass().getName());
            Method setMethod = clazz.getMethod("setAdpRemark", String.class);
            setMethod.invoke(o, adpRemark);
        }
        catch (Exception e) {
            log.error("setMethod \u5931\u8d25\uff0c" + e.getMessage(), (Throwable)e);
        }
    }

    private Object findAdpRemark(Object primaryKeyValue, Class clazz, String collectionName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Criteria criteria = Criteria.where((String)"_id").is(primaryKeyValue).and("adpVersion").is((Object)CurThreadInfoUtils.getAdpVersion());
        Query query = new Query((CriteriaDefinition)criteria);
        MongoMultiVersionsRepositoryDecorator.appendTenantProcessIdQueryCondition(query);
        org.springframework.data.mongodb.core.query.Field fields = query.fields();
        fields.include("adpRemark");
        Object historyObj = this.chooseRepository().findOne(query, clazz);
        Method getAdpRemark = clazz.getMethod("getAdpRemark", new Class[0]);
        if (Objects.isNull(historyObj)) {
            MultiVersionsCollection sysMultiVersionsCollection = VERSIONS_TABLE.get(collectionName);
            return sysMultiVersionsCollection.getAdpRemark();
        }
        return getAdpRemark.invoke(historyObj, new Object[0]);
    }

    public <T> T insert(T t) {
        T res = null;
        if (StringUtils.isNotBlank((CharSequence)CurThreadInfoUtils.getAdpVersion())) {
            String collectionName = this.getCollectionName(t.getClass());
            this.setAdpVersion(t, CurThreadInfoUtils.getAdpVersion());
            this.setTenantProcessId(t, CurThreadInfoUtils.getTenantProcessId());
            if (VersionStatusEnum.RUN_STATE.getCode().equals(CurThreadInfoUtils.getAdpStatus())) {
                res = this.chooseRepository().insert(t);
            }
            if (VERSIONS_TABLE.containsKey(collectionName)) {
                try {
                    MultiVersionsCollection sysMultiVersionsCollection = VERSIONS_TABLE.get(collectionName);
                    Class<?> clazz = Class.forName(t.getClass().getName() + HISTORY_SUFFIX);
                    ObjectMapper objectMapper = new ObjectMapper();
                    String s = objectMapper.writeValueAsString(t);
                    Object historyObj = objectMapper.readValue(s, clazz);
                    if (sysMultiVersionsCollection.getNeedUpdateAdpRemark().booleanValue()) {
                        this.setAdpRemark(historyObj, sysMultiVersionsCollection.getAdpRemark());
                    }
                    return (T)this.chooseRepository().insert(historyObj);
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65\u8868\u6570\u636e\u5f02\u5e38\uff0c" + e.getMessage(), (Throwable)e);
                    throw new RuntimeException("\u540c\u6b65\u8868\u6570\u636e\u5f02\u5e38\uff0c" + e.getMessage());
                }
            }
        } else {
            res = this.chooseRepository().insert(t);
        }
        return res;
    }

    public <T> Collection<? extends T> insertAll(Collection<? extends T> collection) {
        String collectionName = null;
        Collection<T> res = null;
        for (T t : collection) {
            collectionName = this.getCollectionName(t.getClass());
            this.setAdpVersion(t, CurThreadInfoUtils.getAdpVersion());
            this.setTenantProcessId(t, CurThreadInfoUtils.getTenantProcessId());
        }
        if (StringUtils.isNotBlank((CharSequence)CurThreadInfoUtils.getAdpVersion())) {
            if (VersionStatusEnum.RUN_STATE.getCode().equals(CurThreadInfoUtils.getAdpStatus())) {
                res = this.chooseRepository().insertAll(collection);
            }
            if (VERSIONS_TABLE.containsKey(collectionName)) {
                MultiVersionsCollection sysMultiVersionsCollection = VERSIONS_TABLE.get(collectionName);
                ArrayList<Object> historyCollection = new ArrayList<Object>();
                try {
                    if (CollectionUtils.isEmpty(res)) {
                        res = collection;
                    }
                    for (T t : res) {
                        Class<?> clazz = Class.forName(t.getClass().getName() + HISTORY_SUFFIX);
                        ObjectMapper objectMapper = new ObjectMapper();
                        String s = objectMapper.writeValueAsString(t);
                        Object historyObj = objectMapper.readValue(s, clazz);
                        if (sysMultiVersionsCollection.getNeedUpdateAdpRemark().booleanValue()) {
                            this.setAdpRemark(historyObj, "\u6d41\u7a0b\u591a\u7248\u672cV1");
                        }
                        historyCollection.add(historyObj);
                    }
                    this.chooseRepository().insertAll(historyCollection);
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65\u8868\u6570\u636e\u5f02\u5e38\uff0c" + e.getMessage(), (Throwable)e);
                    throw new RuntimeException("\u540c\u6b65\u8868\u6570\u636e\u5f02\u5e38\uff0c" + e.getMessage());
                }
            }
        } else {
            res = this.chooseRepository().insertAll(collection);
        }
        return res;
    }

    public <T> T save(T t) {
        try {
            String collectionName = this.getCollectionName(t.getClass());
            if (this.judgeVersionSync(collectionName).booleanValue()) {
                if (this.judgeKeyHasValue(t).booleanValue()) {
                    this.setAdpVersion(t, CurThreadInfoUtils.getAdpVersion());
                    this.setTenantProcessId(t, CurThreadInfoUtils.getTenantProcessId());
                    Class<?> historyClazz = Class.forName(t.getClass().getName() + HISTORY_SUFFIX);
                    MultiVersionsCollection sysMultiVersionsCollection = VERSIONS_TABLE.get(collectionName);
                    String primaryKey = sysMultiVersionsCollection.getPrimaryKey();
                    Object primaryKeyValue = this.getHistoryPrimaryKeyValue(t, primaryKey);
                    ObjectMapper objectMapper = new ObjectMapper();
                    String s = objectMapper.writeValueAsString(t);
                    Object historyObj = objectMapper.readValue(s, historyClazz);
                    if (sysMultiVersionsCollection.getNeedUpdateAdpRemark().booleanValue()) {
                        Object historyObjRemark = this.findAdpRemark(primaryKeyValue, historyClazz, collectionName);
                        this.setAdpRemark(historyObj, historyObjRemark);
                    }
                    if (VersionStatusEnum.RUN_STATE.getCode().equals(CurThreadInfoUtils.getAdpStatus())) {
                        this.chooseRepository().save(t);
                    }
                    Object res = this.chooseRepository().save(historyObj);
                    return (T)res;
                }
                return this.insert(t);
            }
            return this.chooseRepository().save(t);
        }
        catch (Exception e) {
            log.error("MongoMultiVersionsRepositoryDecorator save \u5f02\u5e38" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("MongoMultiVersionsRepositoryDecorator save \u5f02\u5e38" + e.getMessage());
        }
    }

    public <T> long remove(Query query, String collectionName, Class<T> t) {
        MongoMultiVersionsRepositoryDecorator.appendQueryCondition(query);
        try {
            if (VERSIONS_TABLE.containsKey(collectionName) && !this.hasOtherHeaderFlag().booleanValue()) {
                Class<?> historyClazz = Class.forName(t.getName() + HISTORY_SUFFIX);
                if (StringUtils.isNotBlank((CharSequence)CurThreadInfoUtils.getAdpVersion())) {
                    this.chooseRepository().remove(query, collectionName, t);
                    return this.chooseRepository().remove(query, collectionName + HISTORY_SUFFIX, historyClazz);
                }
                this.chooseRepository().remove(query, collectionName + HISTORY_SUFFIX, historyClazz);
                return this.chooseRepository().remove(query, collectionName, t);
            }
            return this.chooseRepository().remove(query, collectionName, t);
        }
        catch (ClassNotFoundException e) {
            log.error("MongoMultiVersionsRepositoryDecorator remove \u5f02\u5e38" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("MongoMultiVersionsRepositoryDecorator remove \u5f02\u5e38" + e.getMessage());
        }
    }

    public <T> long removeMain(Query query, Class<T> t) {
        MongoMultiVersionsRepositoryDecorator.appendTenantProcessIdQueryCondition(query);
        return this.chooseRepository().remove(query, t);
    }

    public <T> DeleteResult deleteMain(Query query, Class<T> t) {
        MongoMultiVersionsRepositoryDecorator.appendTenantProcessIdQueryCondition(query);
        return this.chooseRepository().delete(query, t);
    }

    public <T> T findMain(Query query, Class<T> t) {
        String collectionName = this.getCollectionName(t);
        return this.chooseRepository().findOne(query, collectionName, t);
    }

    public <T> List<T> findMainList(Query query, Class<T> t) {
        return this.chooseRepository().find(query, t);
    }

    public <T> DeleteResult delete(Query query, Class<T> t) {
        String collectionName = this.getCollectionName(t);
        MongoMultiVersionsRepositoryDecorator.appendQueryCondition(query);
        try {
            if (VERSIONS_TABLE.containsKey(collectionName) && !this.hasOtherHeaderFlag().booleanValue()) {
                Class<?> historyClazz = Class.forName(t.getName() + HISTORY_SUFFIX);
                if (StringUtils.isNotBlank((CharSequence)CurThreadInfoUtils.getAdpVersion())) {
                    this.chooseRepository().delete(query, t);
                    return this.chooseRepository().delete(query, historyClazz);
                }
                this.chooseRepository().delete(query, historyClazz);
                return this.chooseRepository().delete(query, t);
            }
            return this.chooseRepository().delete(query, t);
        }
        catch (ClassNotFoundException e) {
            log.error("MongoMultiVersionsRepositoryDecorator delete \u5f02\u5e38" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("MongoMultiVersionsRepositoryDecorator delete \u5f02\u5e38" + e.getMessage());
        }
    }

    public <T> DeleteResult delete(T t) {
        Object objectIdValue = this.findObjectIdValue(t);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is(objectIdValue));
        return this.delete(query, t.getClass());
    }

    private <T> Object findObjectIdValue(T t) {
        for (Class<?> aClass = t.getClass(); aClass != null && aClass != Object.class; aClass = aClass.getSuperclass()) {
            for (Field field : aClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Id.class)) continue;
                field.setAccessible(true);
                try {
                    return field.get(t);
                }
                catch (IllegalAccessException e) {
                    log.error("findObjectIdValue exception:" + e.getMessage(), (Throwable)e);
                    throw new RuntimeException("findObjectIdValue exception:" + e.getMessage());
                }
            }
        }
        throw new RuntimeException("\u672a\u67e5\u627e\u5230\u5bf9\u8c61\u7684@Id\u5b57\u6bb5\u503c");
    }

    public <T> long remove(Query query, Class<T> t) {
        String collectionName = this.getCollectionName(t);
        return this.remove(query, collectionName, t);
    }

    public <T> List<T> find(Query query, Class<T> t) {
        String collectionName = this.getCollectionName(t);
        return this.find(collectionName, query, t);
    }

    public <T> List<T> find(String collectionName, Query query, Class<T> t) {
        MongoMultiVersionsRepositoryDecorator.appendTenantProcessIdQueryCondition(query);
        try {
            if (this.judgeVersionSync(collectionName).booleanValue()) {
                Class<?> historyClazz = Class.forName(t.getName() + HISTORY_SUFFIX);
                MongoMultiVersionsRepositoryDecorator.appendAdpVersionQueryCondition(query);
                List<?> res = this.chooseRepository().find(collectionName + HISTORY_SUFFIX, query, historyClazz);
                return JSONObject.parseArray((String)JSONObject.toJSONString(res), t);
            }
            return this.chooseRepository().find(collectionName, query, t);
        }
        catch (ClassNotFoundException e) {
            log.error("MongoMultiVersionsRepositoryDecorator find \u5f02\u5e38" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("MongoMultiVersionsRepositoryDecorator find \u5f02\u5e38" + e.getMessage());
        }
    }

    private static void appendAdpVersionQueryCondition(Query query) {
        boolean hasAdpVersion = query.getQueryObject().containsKey((Object)"adpVersion");
        if (!hasAdpVersion && StringUtils.isNotBlank((CharSequence)CurThreadInfoUtils.getAdpVersion())) {
            Criteria adpVersionCriteria = Criteria.where((String)"adpVersion").is((Object)CurThreadInfoUtils.getAdpVersion());
            query.addCriteria((CriteriaDefinition)adpVersionCriteria);
        }
    }

    private static void appendTenantProcessIdQueryCondition(Query query) {
        if (StringUtils.isNotBlank((CharSequence)CurThreadInfoUtils.getTenantProcessId())) {
            Criteria tenantProcessIdCriteria = Criteria.where((String)"tenantProcessId").is((Object)CurThreadInfoUtils.getTenantProcessId());
            query.addCriteria((CriteriaDefinition)tenantProcessIdCriteria);
        }
    }

    private static void appendQueryCondition(Query query) {
        boolean hasAdpVersion = query.getQueryObject().containsKey((Object)"adpVersion");
        if (!hasAdpVersion && !StringUtils.isBlank((CharSequence)CurThreadInfoUtils.getAdpVersion())) {
            Criteria adpVersionCriteria = Criteria.where((String)"adpVersion").is((Object)CurThreadInfoUtils.getAdpVersion());
            query.addCriteria((CriteriaDefinition)adpVersionCriteria);
        }
        if (!StringUtils.isBlank((CharSequence)CurThreadInfoUtils.getTenantProcessId())) {
            Criteria tenantProcessIdCriteria = Criteria.where((String)"tenantProcessId").is((Object)CurThreadInfoUtils.getTenantProcessId());
            query.addCriteria((CriteriaDefinition)tenantProcessIdCriteria);
        }
    }

    public <T> T findOne(Query query, Class<T> t) {
        String collectionName = this.getCollectionName(t);
        return this.findOne(query, collectionName, t);
    }

    public <T> T findOne(Query query, String collectionName, Class<T> t) {
        MongoMultiVersionsRepositoryDecorator.appendTenantProcessIdQueryCondition(query);
        try {
            if (this.judgeVersionSync(collectionName).booleanValue()) {
                Class<?> historyClazz = Class.forName(t.getName() + HISTORY_SUFFIX);
                MongoMultiVersionsRepositoryDecorator.appendAdpVersionQueryCondition(query);
                Object res = this.chooseRepository().findOne(query, collectionName + HISTORY_SUFFIX, historyClazz);
                return (T)JSONObject.parseObject((String)JSONObject.toJSONString(res), t);
            }
            return this.chooseRepository().findOne(query, collectionName, t);
        }
        catch (ClassNotFoundException e) {
            log.error("MongoMultiVersionsRepositoryDecorator findOne \u5f02\u5e38" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("MongoMultiVersionsRepositoryDecorator findOne \u5f02\u5e38" + e.getMessage());
        }
    }

    public long count(Query query, @Nullable Class<?> t) {
        String collectionName = this.getCollectionName(t);
        MongoMultiVersionsRepositoryDecorator.appendTenantProcessIdQueryCondition(query);
        try {
            if (this.judgeVersionSync(collectionName).booleanValue()) {
                Class<?> historyClazz = Class.forName(t.getName() + HISTORY_SUFFIX);
                MongoMultiVersionsRepositoryDecorator.appendAdpVersionQueryCondition(query);
                return this.chooseRepository().count(query, historyClazz);
            }
            return this.chooseRepository().count(query, t);
        }
        catch (ClassNotFoundException e) {
            log.error("MongoMultiVersionsRepositoryDecorator count \u5f02\u5e38" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("MongoMultiVersionsRepositoryDecorator count \u5f02\u5e38" + e.getMessage());
        }
    }

    public <T> UpdateResult updateFirst(Query query, Update update, Class<T> t) {
        String collectionName = this.getCollectionName(t);
        MongoMultiVersionsRepositoryDecorator.appendTenantProcessIdQueryCondition(query);
        try {
            if (this.judgeVersionSync(collectionName).booleanValue()) {
                Class<?> historyClazz = Class.forName(t.getName() + HISTORY_SUFFIX);
                MongoMultiVersionsRepositoryDecorator.appendAdpVersionQueryCondition(query);
                return this.chooseRepository().updateFirst(query, update, historyClazz);
            }
            return this.chooseRepository().updateFirst(query, update, t);
        }
        catch (ClassNotFoundException e) {
            log.error("MongoMultiVersionsRepositoryDecorator count \u5f02\u5e38" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("MongoMultiVersionsRepositoryDecorator count \u5f02\u5e38" + e.getMessage());
        }
    }

    public <T> long updateMulti(Query query, Update update, Class<T> t) {
        String collectionName = this.getCollectionName(t);
        MongoMultiVersionsRepositoryDecorator.appendTenantProcessIdQueryCondition(query);
        try {
            if (this.judgeVersionSync(collectionName).booleanValue()) {
                Class<?> historyClazz = Class.forName(t.getName() + HISTORY_SUFFIX);
                MongoMultiVersionsRepositoryDecorator.appendAdpVersionQueryCondition(query);
                return this.chooseRepository().updateMulti(query, update, historyClazz);
            }
            return this.chooseRepository().updateMulti(query, update, t);
        }
        catch (ClassNotFoundException e) {
            log.error("MongoMultiVersionsRepositoryDecorator count \u5f02\u5e38" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("MongoMultiVersionsRepositoryDecorator count \u5f02\u5e38" + e.getMessage());
        }
    }
}

