package com.digiwin.athena.config.http;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpInterceptor;
import cn.hutool.http.HttpRequest;
import com.digiwin.athena.constant.Constant;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.StringUtils;

public class HutoolRouterKeyInterceptor implements HttpInterceptor<HttpRequest> {

    private String appToken;

    public HutoolRouterKeyInterceptor(String appToken) {
        this.appToken = appToken;
    }

    @Override
    public void process(HttpRequest request) {
        if (StrUtil.isBlank(request.header("locale"))) {
            request.header("locale", LocaleContextHolder.getLocale().toString());
        }
        if (StrUtil.isBlank(request.header(Constant.APP_TOKEN))) {
            request.header(Constant.APP_TOKEN, appToken);
        }

        if (StringUtils.isEmpty(request.header(Constant.ROUTER_KEY))) {
            String tenantId = CurThreadInfoUtils.getRouterKey();
            // 在每个请求header中添加routerKey
            if (!StringUtils.isEmpty(tenantId)) {
                request.header(Constant.ROUTER_KEY, tenantId);
            } else {
                request.header(Constant.ROUTER_KEY, "noRouterKey");
            }
        }
    }
}
