/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.config;

import com.digiwin.athena.config.CustomTaskDecorator;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableAsync(proxyTargetClass=true)
@Configuration
public class ThreadPoolConfig {
    @Bean(value={"gptExecutor"})
    public Executor taskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(20);
        executor.setMaxPoolSize(30);
        executor.setQueueCapacity(1000);
        executor.setKeepAliveSeconds(60);
        executor.setThreadNamePrefix("asyncGPTServiceExecutor -");
        executor.setTaskDecorator((TaskDecorator)new CustomTaskDecorator());
        executor.setAwaitTerminationSeconds(60);
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.initialize();
        return executor;
    }

    @Bean(value={"asyncExecutor"})
    public Executor getAsyncExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(5);
        taskExecutor.setMaxPoolSize(10);
        taskExecutor.setQueueCapacity(100);
        taskExecutor.initialize();
        return taskExecutor;
    }

    @Bean(value={"asaModelExecutor"})
    public Executor asaModelExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(5);
        executor.setMaxPoolSize(100);
        executor.setQueueCapacity(100);
        executor.initialize();
        return executor;
    }

    @Bean
    public ThreadPoolExecutor securityTaskProcessPool() {
        return new ThreadPoolExecutor(5, 10, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1000), new CustomDefaultThreadFactory("securityTaskProcess"), new ThreadPoolExecutor.DiscardPolicy());
    }

    @Bean
    public ThreadPoolExecutor businessTaskProcessPool() {
        return new ThreadPoolExecutor(5, 10, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10000), new CustomDefaultThreadFactory("businessTaskProcess"), new ThreadPoolExecutor.DiscardPolicy());
    }

    @Bean
    public ThreadPoolExecutor dataCenterTaskProcessPool() {
        return new ThreadPoolExecutor(5, 10, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10000), new CustomDefaultThreadFactory("dataCenterProcess"), new ThreadPoolExecutor.DiscardPolicy());
    }

    @Bean
    public ThreadPoolExecutor createNewBranchPool() {
        return new ThreadPoolExecutor(5, 10, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1000), new CustomDefaultThreadFactory("createNewBranchPool"), new ThreadPoolExecutor.DiscardPolicy());
    }

    @Bean
    public ThreadPoolExecutor agileDataBusinessPool() {
        return new ThreadPoolExecutor(5, 10, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(2000), new CustomDefaultThreadFactory("agileDataBusinessPool"), new ThreadPoolExecutor.DiscardPolicy());
    }

    @Bean
    public ThreadPoolExecutor assetCenterPool() {
        return new ThreadPoolExecutor(5, 10, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1000), new CustomDefaultThreadFactory("assetCenterPool"), new ThreadPoolExecutor.DiscardPolicy());
    }

    static class CustomDefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        CustomDefaultThreadFactory(String threadPrefix) {
            this.group = Thread.currentThread().getThreadGroup();
            this.namePrefix = threadPrefix + "-pool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

