package com.digiwin.athena.config;

import io.jsonwebtoken.SignatureAlgorithm;
import jakarta.xml.bind.DatatypeConverter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.crypto.spec.SecretKeySpec;
import java.security.Key;

@Configuration
public class FxJwtConfig {

    @Value("${fxJwtPrivateKey}")
    private String fxJwtPrivateKey;

    @Bean
    public Key fxJwtKey(){
        SignatureAlgorithm SIGNATURE_ALGORITHM = SignatureAlgorithm.HS512;
        byte[] API_BYTES_KEY = DatatypeConverter.parseBase64Binary(fxJwtPrivateKey);
        Key SIGNING_KEY = new SecretKeySpec(API_BYTES_KEY, SIGNATURE_ALGORITHM.getJcaName());
        return SIGNING_KEY;
    }
}
