/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.mongodb.repository;

import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Repository;

@Repository(value="mongoDynamicRepository")
public class MongoRepository
implements ApplicationContextAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MongoRepository.class);
    @Value(value="${spring.data.mongodb.uri}")
    private String uri;
    private static final Map<String, MongoTemplate> MONGO_TEMPLATE_CACHE = new HashMap<String, MongoTemplate>(16);

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map mongoTemplateMap = applicationContext.getBeansOfType(MongoTemplate.class);
        for (MongoTemplate mongoTemplate : mongoTemplateMap.values()) {
            MONGO_TEMPLATE_CACHE.put(mongoTemplate.getDb().getName(), mongoTemplate);
        }
        log.info("mongo\u6620\u5c04" + MONGO_TEMPLATE_CACHE);
    }

    public <T> T insert(String databaseName, T t) {
        return (T)MONGO_TEMPLATE_CACHE.get(databaseName).insert(t);
    }

    public <T> UpdateResult upsert(String dbName, Query query, Update update, String collection) {
        return MONGO_TEMPLATE_CACHE.get(dbName).upsert(query, (UpdateDefinition)update, collection);
    }

    public <T> T insert(String databaseName, String collectionName, T t) {
        return (T)MONGO_TEMPLATE_CACHE.get(databaseName).insert(t, collectionName);
    }

    public <T> T save(String databaseName, T t) {
        return (T)MONGO_TEMPLATE_CACHE.get(databaseName).save(t);
    }

    public <T> T save(String databaseName, String collectionName, T t) {
        return (T)MONGO_TEMPLATE_CACHE.get(databaseName).save(t, collectionName);
    }

    public <T> void insertAll(String databaseName, Class<T> tClass, List<T> tList) {
        MONGO_TEMPLATE_CACHE.get(databaseName).insert(tList, tClass);
    }

    public <T> void insertAll(String databaseName, String collectionName, List<T> tList) {
        MONGO_TEMPLATE_CACHE.get(databaseName).insert(tList, collectionName);
    }

    public <T> DeleteResult delete(String databaseName, T obj) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).remove(obj);
    }

    public <T> DeleteResult delete(String databaseName, T obj, String collectionName) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).remove(obj, collectionName);
    }

    public <T> long remove(String databaseName, Class<T> tClass, Query query) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).remove(query, tClass).getDeletedCount();
    }

    public <T> DeleteResult delete(String databaseName, Class<T> tClass, Query query) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).remove(query, tClass);
    }

    public long remove(String databaseName, String collectionName, Query query) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).remove(query, collectionName).getDeletedCount();
    }

    public <T> UpdateResult updateFirst(String databaseName, Class<T> tClass, Query query, Update update) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).updateFirst(query, (UpdateDefinition)update, tClass);
    }

    public <T> UpdateResult updateFirst(String databaseName, String collection, Query query, Update update) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).updateFirst(query, (UpdateDefinition)update, collection);
    }

    public <T> long updateMulti(String databaseName, Class<T> tClass, Query query, Update update) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).updateMulti(query, (UpdateDefinition)update, tClass).getModifiedCount();
    }

    public long updateMulti(String databaseName, String collectionName, Query query, Update update) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).updateMulti(query, (UpdateDefinition)update, collectionName).getModifiedCount();
    }

    public <T> List<T> find(String databaseName, Class<T> tClass, Query query) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).find(query, tClass);
    }

    public <T> List<T> findAll(String databaseName, Class<T> tClass) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).findAll(tClass);
    }

    public <T> List<T> findAll(String databaseName, String collectionName, Class<T> tClass) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).findAll(tClass, collectionName);
    }

    public <T> List<T> find(String databaseName, String collectionName, Query query, Class<T> tClass) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).find(query, tClass, collectionName);
    }

    public <T> T findOne(String databaseName, Class<T> tClass, Query query) {
        return (T)MONGO_TEMPLATE_CACHE.get(databaseName).findOne(query, tClass);
    }

    public <T> T findOne(String databaseName, Class<T> tClass, String collectionName, Query query) {
        return (T)MONGO_TEMPLATE_CACHE.get(databaseName).findOne(query, tClass, collectionName);
    }

    public long count(String databaseName, Query query, @Nullable Class<?> entityClass) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).count(query, entityClass);
    }

    public <T> Page<T> findWithPage(String databaseName, Pageable pageable, Class<T> tClass, Query query) {
        List<T> resultList = this.find(databaseName, tClass, query.with(pageable));
        return PageableExecutionUtils.getPage(resultList, (Pageable)pageable, () -> this.count(databaseName, Query.of((Query)query).limit(-1).skip(-1L), tClass));
    }

    public Set<String> getDbCollectionNames(String databaseName) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).getCollectionNames();
    }

    public <T> T findById(String databaseName, Object id, Class<T> entityClass) {
        return (T)MONGO_TEMPLATE_CACHE.get(databaseName).findById(id, entityClass);
    }

    public <T> Collection<T> insertAll(String databaseName, Collection<? extends T> collection) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).insertAll(collection);
    }

    public <T> T findOne(String databaseName, Query query, Class<T> entityClass, String collectionName) {
        return (T)MONGO_TEMPLATE_CACHE.get(databaseName).findOne(query, entityClass, collectionName);
    }

    public <T> List<T> find(String databaseName, Query query, Class<T> entityClass, String collectionName) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).find(query, entityClass, collectionName);
    }

    public DeleteResult remove(String databaseName, Query query, String collectionName) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).remove(query, collectionName);
    }

    public <T> T save(String databaseName, T objectToSave, String collectionName) {
        return (T)MONGO_TEMPLATE_CACHE.get(databaseName).save(objectToSave, collectionName);
    }

    public long count(String databaseName, Query query, @Nullable Class<?> entityClass, String collectionName) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).count(query, entityClass, collectionName);
    }

    public <T> Collection<T> insert(String databaseName, Collection<? extends T> batchToSave, Class<?> entityClass) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).insert(batchToSave, entityClass);
    }

    public <T> T insert(String databaseName, T objectToSave, String collectionName) {
        return (T)MONGO_TEMPLATE_CACHE.get(databaseName).insert(objectToSave, collectionName);
    }

    public MongoDatabaseFactory getMongoDbFactory(String databaseName) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).getMongoDatabaseFactory();
    }

    public <T> List<T> findAllAndRemove(String databaseName, Query query, Class<T> entityClass, String collectionName) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).findAllAndRemove(query, entityClass, collectionName);
    }

    public boolean exists(String databaseName, Query query, @Nullable Class<?> entityClass, String collectionName) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).exists(query, entityClass, collectionName);
    }

    public <O> AggregationResults<O> aggregate(String databaseName, Aggregation aggregation, Class<?> inputType, Class<O> outputType) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).aggregate(aggregation, inputType, outputType);
    }

    public <O> AggregationResults<O> aggregate(String databaseName, TypedAggregation<?> aggregation, Class<O> outputType) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).aggregate(aggregation, outputType);
    }

    public <O> AggregationResults<O> aggregate(String databaseName, Aggregation aggregation, String collectioName, Class<O> outputType) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).aggregate(aggregation, collectioName, outputType);
    }

    public BulkOperations bulkOps(String databaseName, BulkOperations.BulkMode mode, Class<?> entityType) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).bulkOps(mode, entityType);
    }

    public Set<String> getCollectionNames(String databaseName) {
        return MONGO_TEMPLATE_CACHE.get(databaseName).getCollectionNames();
    }

    public MongoTemplate getTargetMongoTemplate(String databaseName) {
        return MONGO_TEMPLATE_CACHE.get(databaseName);
    }
}

