package com.digiwin.athena.config;

import com.digiwin.athena.utils.RequestShareUtil;
import org.springframework.core.task.TaskDecorator;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import jakarta.servlet.http.HttpServletRequest;

public class CustomTaskDecorator implements TaskDecorator {
    private String header;

    @Override
    public Runnable decorate(Runnable runnable) {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        if(requestAttributes != null){
            HttpServletRequest request = requestAttributes.getRequest();
            if(request != null){
                this.header = request.getHeader("digi-middleware-auth-user");
            }
        }
        return () -> {
            try {
                RequestShareUtil.shareToken(this.header);
                runnable.run();
            } finally {
                RequestShareUtil.remove();
            }
        };
    }
}
