package com.digiwin.athena.config.http;


import com.digiwin.athena.constant.Constant;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.io.IOException;

@Component
public class RestTemplateAddHeadersInterceptor implements ClientHttpRequestInterceptor {

    @Value("${rest-url.appToken}")
    private String appToken;

    @Override
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {

        HttpHeaders headers = request.getHeaders();

        if (!headers.containsKey("locale")) {
            headers.add("locale", LocaleContextHolder.getLocale().toString());
        }
        if (!headers.containsKey(Constant.APP_TOKEN)) {
            headers.add(Constant.APP_TOKEN, appToken);
        }
        //添加routerKey,有传递则使用传递的，没传递，则使用当前登陆用户的。
        if (!headers.containsKey(Constant.ROUTER_KEY)) {
            String tenantId = CurThreadInfoUtils.getRouterKey();
            if (!StringUtils.isEmpty(tenantId)) {
                headers.add(Constant.ROUTER_KEY, tenantId);
            } else {
                headers.add(Constant.ROUTER_KEY, "noRouterKey");
            }
        }

        // 保证请求继续被执行
        return execution.execute(request, body);
    }
}
