package com.digiwin.athena.config.http;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

/**
 * <Description> <br>
 *
 * @author wang.xinyuan<br>
 * @version 1.0<br>
 * @CreateDate 2023/3/17 <br>
 */

@Configuration
public class RestTemplateHttpConfig {

    @Bean
    RestTemplateAddHeadersInterceptor httpRestTemplateInterceptor(@Qualifier("httpRestTemplate") RestTemplate restTemplate) {
        RestTemplateAddHeadersInterceptor restTemplateAddTokenInterceptor = new RestTemplateAddHeadersInterceptor();
        restTemplate.getInterceptors().add(restTemplateAddTokenInterceptor);
        return restTemplateAddTokenInterceptor;
    }

    @Bean
    RestTemplateAddHeadersInterceptor httpsRestTemplateInterceptor(@Qualifier("httpsRestTemplate") RestTemplate restTemplate) {
        RestTemplateAddHeadersInterceptor restTemplateAddTokenInterceptor = new RestTemplateAddHeadersInterceptor();
        restTemplate.getInterceptors().add(restTemplateAddTokenInterceptor);
        return restTemplateAddTokenInterceptor;
    }

    @Bean
    RestTemplateAddHeadersInterceptor iamRestTemplateInterceptor(@Qualifier("iamRestTemplate") RestTemplate restTemplate) {
        RestTemplateAddHeadersInterceptor restTemplateAddTokenInterceptor = new RestTemplateAddHeadersInterceptor();
        restTemplate.getInterceptors().add(restTemplateAddTokenInterceptor);
        return restTemplateAddTokenInterceptor;
    }

    @Bean
    RestTemplateAddHeadersInterceptor gitLabRestTemplateInterceptor(@Qualifier("gitLabRestTemplate") RestTemplate restTemplate) {
        RestTemplateAddHeadersInterceptor restTemplateAddTokenInterceptor = new RestTemplateAddHeadersInterceptor();
        restTemplate.getInterceptors().add(restTemplateAddTokenInterceptor);
        return restTemplateAddTokenInterceptor;
    }

    @Bean
    RestTemplateAddHeadersInterceptor dmcRestTemplateInterceptor(@Qualifier("dmcRestTemplate") RestTemplate restTemplate) {
        RestTemplateAddHeadersInterceptor restTemplateAddTokenInterceptor = new RestTemplateAddHeadersInterceptor();
        restTemplate.getInterceptors().add(restTemplateAddTokenInterceptor);
        return restTemplateAddTokenInterceptor;
    }

}