package com.digiwin.athena.mongodb.repository;

import com.digiwin.athena.config.BranchConfig;
import com.digiwin.athena.config.mongodb.MongodbConfig;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;

@Slf4j
@Repository
public class MongoPrimaryRepositoryDecorator extends MongoUserRepositoryDecorator{

    @Autowired
    private MongodbConfig mongodbConfig;

    private final static Map<String,String> BRANCH_DB_NAME_MAP= new HashMap<>();

    @PostConstruct
    public void initMethod(){
        BRANCH_DB_NAME_MAP.put(BranchConfig.DEV_BRANCH_NAME,mongodbConfig.getDatabase());
    }
    @Override
    Map<String, String> getBranchDBNameMap() {
        return BRANCH_DB_NAME_MAP;
    }

    @Override
    String getBranchName() {
        return BranchConfig.DEV_BRANCH_NAME;
    }
}
