/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.config.http;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.base.BusinessException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;

public class RestTemplateLogInterceptor
implements ClientHttpRequestInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestTemplateLogInterceptor.class);

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        log.info(String.format("restTemplateLog \u8bf7\u6c42\u8def\u5f84:%s,\u8bf7\u6c42\u5934:%s,\u8bf7\u6c42\u53c2\u6570:%s", request.getURI(), JSONObject.toJSONString((Object)request.getHeaders()), new String(body)));
        ClientHttpResponse response = execution.execute(request, body);
        BufferingClientHttpResponseWrapper responseWrapper = new BufferingClientHttpResponseWrapper(response);
        String responseBody = StreamUtils.copyToString((InputStream)responseWrapper.getBody(), (Charset)StandardCharsets.UTF_8);
        log.info(String.format("restTemplateLog \u8bf7\u6c42\u8def\u5f84:%s , \u54cd\u5e94responseBody:%s", request.getURI(), responseBody));
        if (response.getStatusCode() != HttpStatus.OK) {
            log.error(String.format("restTemplateLog uri:%s \u8bf7\u6c42\u5f02\u5e38:%s", request.getURI(), response.getStatusCode().value()));
            throw new BusinessException(request.getURI() + " \u8bf7\u6c42\u5f02\u5e38:" + responseBody);
        }
        return responseWrapper;
    }

    private static class BufferingClientHttpResponseWrapper
    implements ClientHttpResponse {
        private final ClientHttpResponse response;
        private byte[] body;

        public BufferingClientHttpResponseWrapper(ClientHttpResponse response) throws IOException {
            this.response = response;
            this.body = StreamUtils.copyToByteArray((InputStream)response.getBody());
        }

        public InputStream getBody() throws IOException {
            return new ByteArrayInputStream(this.body);
        }

        public HttpStatusCode getStatusCode() throws IOException {
            return this.response.getStatusCode();
        }

        public String getStatusText() throws IOException {
            return this.response.getStatusText();
        }

        public void close() {
            this.response.close();
        }

        public HttpHeaders getHeaders() {
            return this.response.getHeaders();
        }
    }
}

