/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.athena.domain.StandardDictionaryPO;
import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class StandardDictionaryMongoDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StandardDictionaryMongoDao.class);
    @Resource
    private MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;
    private final MongoTemplate mongoTemplate;

    @Autowired
    public StandardDictionaryMongoDao(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public void insert(List<StandardDictionaryPO> standardDictionaryPOList) {
        this.mongoSystemRepositoryDecorator.insertAll(standardDictionaryPOList);
    }

    public void update(StandardDictionaryPO standardDictionaryPO) {
        this.mongoSystemRepositoryDecorator.save((Object)standardDictionaryPO);
    }

    public List<StandardDictionaryPO> selectByCode(List<String> codes) {
        Criteria criteria = Criteria.where((String)"code").in(codes);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoSystemRepositoryDecorator.find(query, StandardDictionaryPO.class);
    }

    public List<StandardDictionaryPO> selectAll() {
        return this.mongoSystemRepositoryDecorator.findAll(StandardDictionaryPO.class);
    }

    public List<String> selectAllTenantId() {
        return this.mongoSystemRepositoryDecorator.findAll(StandardDictionaryPO.class).stream().map(StandardDictionaryPO::getTenantId).toList();
    }

    public Page<StandardDictionaryPO> queryModelDrivenInnerISV(Page<StandardDictionaryPO> page, List<String> teamIds, String auditStatus, String condition) {
        Criteria criteria = this.buildMatchCriteria(teamIds, auditStatus, condition);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"editTime"}));
        long count = this.mongoSystemRepositoryDecorator.count(query, StandardDictionaryPO.class);
        page.setTotal(count);
        query.limit(Long.valueOf(page.getSize()).intValue());
        query.skip((page.getCurrent() - 1L) * page.getSize());
        List standardDictionaryPOS = this.mongoSystemRepositoryDecorator.find(query, StandardDictionaryPO.class);
        page.setRecords(standardDictionaryPOS);
        return page;
    }

    private Criteria buildMatchCriteria(List<String> teamIds, String auditStatus, String condition) {
        Criteria criteria = Criteria.where((String)"teamId").in(teamIds);
        criteria = criteria.and(String.valueOf(Criteria.where((String)"standard").is((Object)"N").orOperator(new Criteria[]{Criteria.where((String)"standard").is((Object)"Y").and("auditStatus").is((Object)auditStatus)})));
        if (condition != null && !"".equals(condition)) {
            Criteria keyCriteria = Criteria.where((String)"key").regex(".*" + condition + ".*");
            Criteria descCriteria = Criteria.where((String)"description").regex(".*" + condition + ".*");
            Criteria valuesCriteria = Criteria.where((String)"values").regex(".*" + condition + ".*");
            criteria.orOperator(new Criteria[]{keyCriteria, descCriteria, valuesCriteria});
        }
        return criteria;
    }

    public Page<StandardDictionaryPO> queryModelDrivenOuterISV(Page<StandardDictionaryPO> page, String tenantId, List<String> teamIds, String auditStatus, String condition) {
        Criteria criteria = this.buildMatchCriteria(tenantId, teamIds, auditStatus, condition);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"editTime"}));
        long count = this.mongoSystemRepositoryDecorator.count(query, StandardDictionaryPO.class);
        page.setTotal(count);
        query.limit(Long.valueOf(page.getSize()).intValue());
        query.skip((page.getCurrent() - 1L) * page.getSize());
        List standardDictionaryPOS = this.mongoSystemRepositoryDecorator.find(query, StandardDictionaryPO.class);
        page.setRecords(standardDictionaryPOS);
        return page;
    }

    private Criteria buildMatchCriteria(String tenantId, List<String> teamIds, String auditStatus, String condition) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = new Criteria();
        Criteria criteria2 = Criteria.where((String)"standard").is((Object)"N").orOperator(new Criteria[]{Criteria.where((String)"standard").is((Object)"Y").and("audit_status").is((Object)auditStatus)});
        Criteria.where((String)"tenant_id").is((Object)tenantId).andOperator(new Criteria[]{criteria2});
        Criteria criteria3 = Criteria.where((String)"standard").is((Object)"Y").and("audit_status").is((Object)auditStatus).and("team_id").in(teamIds);
        Criteria criteria4 = new Criteria();
        criteria4.orOperator(new Criteria[]{criteria1, criteria3});
        if (condition != null && !"".equals(condition)) {
            Criteria criteria5 = new Criteria();
            Criteria keyCriteria = Criteria.where((String)"key").regex(".*" + condition + ".*");
            Criteria descCriteria = Criteria.where((String)"description").regex(".*" + condition + ".*");
            Criteria valuesCriteria = Criteria.where((String)"values").regex(".*" + condition + ".*");
            criteria5.orOperator(new Criteria[]{keyCriteria, descCriteria, valuesCriteria});
            criteria.andOperator(new Criteria[]{criteria4, criteria5});
        } else {
            criteria.andOperator(new Criteria[]{criteria4});
        }
        return criteria;
    }

    public Page<StandardDictionaryPO> queryInnerISV(Page<StandardDictionaryPO> page, List<String> teamIds, String auditStatus, String condition, String standard) {
        Criteria criteria = this.buildMatchCriteria(teamIds, auditStatus, condition, standard);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"editTime"}));
        long count = this.mongoSystemRepositoryDecorator.count(query, StandardDictionaryPO.class);
        page.setTotal(count);
        query.limit(Long.valueOf(page.getSize()).intValue());
        query.skip((page.getCurrent() - 1L) * page.getSize());
        List standardDictionaryPOS = this.mongoSystemRepositoryDecorator.find(query, StandardDictionaryPO.class);
        page.setRecords(standardDictionaryPOS);
        return page;
    }

    private Criteria buildMatchCriteria(List<String> teamIds, String auditStatus, String condition, String standard) {
        Criteria criteria = Criteria.where((String)"teamId").in(teamIds);
        if (auditStatus != null && !"".equals(auditStatus)) {
            criteria = criteria.and("auditStatus").is((Object)auditStatus);
        }
        if (standard != null && !"".equals(standard)) {
            criteria = criteria.and("standard").is((Object)standard);
        }
        if (condition != null && !"".equals(condition)) {
            Criteria keyCriteria = Criteria.where((String)"key").regex(".*" + condition + ".*");
            Criteria descCriteria = Criteria.where((String)"description").regex(".*" + condition + ".*");
            Criteria valuesCriteria = Criteria.where((String)"values").regex(".*" + condition + ".*");
            criteria.orOperator(new Criteria[]{keyCriteria, descCriteria, valuesCriteria});
        }
        return criteria;
    }

    public Page<StandardDictionaryPO> queryOuterISV(Page<StandardDictionaryPO> page, String tenantId, List<String> teamIds, String auditStatus, String condition, String standard) {
        Criteria criteria = this.buildMatchCriteria(tenantId, teamIds, auditStatus, condition, standard);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"editTime"}));
        long count = this.mongoSystemRepositoryDecorator.count(query, StandardDictionaryPO.class);
        page.setTotal(count);
        query.limit(Long.valueOf(page.getSize()).intValue());
        query.skip((page.getCurrent() - 1L) * page.getSize());
        List standardDictionaryPOS = this.mongoSystemRepositoryDecorator.find(query, StandardDictionaryPO.class);
        page.setRecords(standardDictionaryPOS);
        return page;
    }

    private Criteria buildMatchCriteria(String tenantId, List<String> teamIds, String auditStatus, String condition, String standard) {
        Criteria criteria = new Criteria();
        ArrayList<Criteria> orCriteria = new ArrayList<Criteria>();
        if (teamIds != null && !teamIds.isEmpty()) {
            Criteria teamIdCriteria = Criteria.where((String)"teamId").in(teamIds);
            if (StringUtils.isNotEmpty((CharSequence)standard)) {
                teamIdCriteria.and("standard").is((Object)standard);
            }
            if (StringUtils.isNotEmpty((CharSequence)auditStatus)) {
                teamIdCriteria.and("auditStatus").is((Object)auditStatus);
            }
            orCriteria.add(teamIdCriteria);
        }
        Criteria tenantIdCriteria = Criteria.where((String)"tenantId").is((Object)tenantId);
        if (StringUtils.isNotEmpty((CharSequence)auditStatus)) {
            tenantIdCriteria = tenantIdCriteria.and("auditStatus").is((Object)auditStatus);
        }
        if (StringUtils.isNotEmpty((CharSequence)standard)) {
            tenantIdCriteria.and("standard").is((Object)standard);
        }
        orCriteria.add(tenantIdCriteria);
        if (condition != null && !"".equals(condition)) {
            Criteria keyCriteria = Criteria.where((String)"key").regex(".*" + condition + ".*");
            Criteria descCriteria = Criteria.where((String)"description").regex(".*" + condition + ".*");
            Criteria valuesCriteria = Criteria.where((String)"values").regex(".*" + condition + ".*");
            Criteria criteria1 = new Criteria();
            criteria1.orOperator(new Criteria[]{keyCriteria, descCriteria, valuesCriteria});
            criteria.andOperator(new Criteria[]{criteria1});
        }
        if (!orCriteria.isEmpty()) {
            criteria.orOperator(orCriteria);
        }
        return criteria;
    }

    public List<StandardDictionaryPO> selectByTenantId(String tenantId) {
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoSystemRepositoryDecorator.find(query, StandardDictionaryPO.class);
    }

    public StandardDictionaryPO selectOneByCondition(Criteria criteria) {
        Query query = new Query((CriteriaDefinition)criteria);
        return (StandardDictionaryPO)this.mongoSystemRepositoryDecorator.findOne(query, StandardDictionaryPO.class);
    }

    public List<StandardDictionaryPO> selectListByCondition(Criteria criteria) {
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoSystemRepositoryDecorator.find(query, StandardDictionaryPO.class);
    }

    public IPage<StandardDictionaryPO> selectPageByCondition(IPage<StandardDictionaryPO> page, Criteria criteria) {
        Query query = new Query((CriteriaDefinition)criteria);
        return (IPage)this.mongoSystemRepositoryDecorator.findWithPage((Pageable)PageRequest.of((int)((int)page.getPages()), (int)((int)page.getSize())), query, StandardDictionaryPO.class);
    }

    public void deleteListByCondition(Criteria criteria) {
        Query query = new Query((CriteriaDefinition)criteria);
        this.mongoSystemRepositoryDecorator.delete(query, StandardDictionaryPO.class);
    }
}

