package com.digiwin.athena.controller;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.domain.RuntimeDictionary;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.service.RDataStandardService;
import com.digiwin.athena.service.RuntimeDataQuery;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/dataStandard/r")
@Tag(name = "查询运行时数据标准",description = "3690c197-cc64-4401-a844-fc18062b76b7")
public class RDataStandardController {

    @Autowired
    @Qualifier("dictionaryRuntime")
    private RuntimeDataQuery<List<RuntimeDictionary>> runtimeDataQuery;

    @GetMapping("/getDictionary")
    @Operation(summary = "查询下拉词汇")
    public ResultDto<List<RuntimeDictionary>> getDictionary(String key){
        JSONObject params = new JSONObject();
        params.put("key",key);
        return ResultDto.createSuccess(runtimeDataQuery.queryRuntimeData(params));
    }
}
