package com.digiwin.athena.domain;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;

@Data
@Document(collection = "tStandardWordDictionary")
@NoArgsConstructor
@AllArgsConstructor
public class WordDictionaryManagePO {
    @Id
    private String id;
    private String dataName;// 辞汇编号
    private String descriptionZhTw;
    private String descriptionZhCn;
    private String descriptionEnUs;
    private String typeZhTw;
    private String typeZhCn;
    private String typeEnUs;
    private String unitOrDefaultZhTw;
    private String unitOrDefaultZhCn;
    private String unitOrDefaultEnUs;

    private String tagZhTw;
    private String tagZhCn;
    private String tagEnUs;

    private String remarkZhTw;
    private String remarkZhCn;
    private String remarkEnUs;

    private int approvedStatus = 0;

    private String buildAcct;
    private Date buildTime;

    private String approvedAcct;

    private Date approvedTime;

    private Date lastUpdateTime;

    private int dirty = 0;
//    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String relateBusinessTypeId;
//    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String relateDictionaryId;
    private String likenessWord;
    private String standard;
    private String manageStatus;
    // 1 非标无需审核，2 待审核，3 已审核
    private String auditStatus;

    private Long systemId;

    private String tenantId;

    private String teamId;

    private Date editTime;

    private String editBy;

    private Date createTime;

    private String createBy;
}
