package com.digiwin.athena.dao;

import com.digiwin.athena.domain.RuntimeDictionary;
import com.digiwin.athena.mongodb.repository.MongoRuntimeRepositoryDecorator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Slf4j
@Repository
public class RuntimeDictionaryMongoDao {
    @Autowired
    private MongoRuntimeRepositoryDecorator mongoRuntimeRepositoryDecorator;

    public void deleteByTenantId(String tenantId) {
        Criteria criteria = Criteria.where("tenantId").is(tenantId);
        mongoRuntimeRepositoryDecorator.delete(new Query(criteria), RuntimeDictionary.class);
    }

    public void insertAll(List<RuntimeDictionary> runtimeDictionaries) {
        mongoRuntimeRepositoryDecorator.insertAll(runtimeDictionaries);
    }

    public List<RuntimeDictionary> selectByKey(String key) {
        Criteria criteria = Criteria.where("key").is(key);
        return mongoRuntimeRepositoryDecorator.find(new Query(criteria),RuntimeDictionary.class);
    }
}
