package com.digiwin.athena.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.digiwin.athena.domain.BusinessTypeManagePO;
import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Slf4j
@Repository
public class BusinessTypeMongoDao {

    @Resource
    private MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;

    public void insert(List<BusinessTypeManagePO> businessTypeManagePOList) {
        mongoSystemRepositoryDecorator.insertAll(businessTypeManagePOList);
    }

    public void update(BusinessTypeManagePO businessTypeManagePO) {
        mongoSystemRepositoryDecorator.save(businessTypeManagePO);
    }

    public List<Map> selectColums(String tableName, String dataBase) {
        Criteria criteria = Criteria.where("tableName").is(tableName).and("dataBase").is(dataBase);
        Query query = new Query(criteria);
        List<BusinessTypeManagePO> businessTypeManagePOList = mongoSystemRepositoryDecorator.find(query, BusinessTypeManagePO.class);
        return businessTypeManagePOList.stream().map(po -> new ObjectMapper().convertValue(po, Map.class)).toList();
    }

    public List<BusinessTypeManagePO> selectByCode(List<String> codes) {
        Criteria criteria = Criteria.where("code").in(codes);
        Query query = new Query(criteria);
        return mongoSystemRepositoryDecorator.find(query, BusinessTypeManagePO.class);
    }

    public List<BusinessTypeManagePO> selectAll() {
        return mongoSystemRepositoryDecorator.findAll(BusinessTypeManagePO.class);
    }

    public List<String> selectAllTenantId() {
        return mongoSystemRepositoryDecorator.findAll(BusinessTypeManagePO.class)
                .stream()
                .map(BusinessTypeManagePO::getTenantId)
                .toList();
    }

    public BusinessTypeManagePO selectByTenantId(Integer id) {
        Criteria criteria = Criteria.where("id").is(id);
        Query query = new Query(criteria);
        return mongoSystemRepositoryDecorator.findOne(query, BusinessTypeManagePO.class);
    }

    public BusinessTypeManagePO selectOneByCondition(Criteria criteria) {
        Query query = new Query(criteria);
        return mongoSystemRepositoryDecorator.findOne(query, BusinessTypeManagePO.class);
    }

    public List<BusinessTypeManagePO> selectListByCondition(Criteria criteria) {
        Query query = new Query(criteria);
        return mongoSystemRepositoryDecorator.find(query, BusinessTypeManagePO.class);
    }

    public IPage<BusinessTypeManagePO> selectPageByCondition(IPage<BusinessTypeManagePO> page, Criteria criteria) {
        Query query = new Query(criteria);
        return (IPage<BusinessTypeManagePO>) mongoSystemRepositoryDecorator.findWithPage(PageRequest.of((int) page.getPages(), (int) page.getSize()), query, BusinessTypeManagePO.class);
    }

    public void deleteListByCondition(Criteria criteria) {
        Query query = new Query(criteria);
        mongoSystemRepositoryDecorator.delete(query, BusinessTypeManagePO.class);
    }

}
