package com.digiwin.athena.domain.datastandard;

import com.digiwin.athena.domain.dictionary.DictionaryValue;
import lombok.Data;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Data
public class StandardDictionaryVO {
    // id
    private String id;
    // 枚举key
    private String key;
    // 枚举key的描述
    private String description;
    // key对应的value
    private List<DictionaryValue> values;
    // 应用code
    private String application;
    // "Y/N" -- 标准(是/否)
    private String standard;

    // 是tenantId_key的组合
    private String enumKey;
    // 多语言
    private Map<String, Map<String,String>> lang;

    // 1 非标无需审核，2 待审核，3 已审核
    private String auditStatus;
    private Long systemId;
    private String tenantId;

    private String teamId;

    private Date editTime;

    private String editBy;

    private Date createTime;

    private String createBy;
}
