package com.digiwin.athena.utils;

import com.digiwin.athena.domain.datastandard.StandardDictionaryVO;
import com.digiwin.athena.domain.dictionary.DictionaryValue;
import com.digiwin.athena.domain.StandardDictionaryPO;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description: 数据标准工具类
 * @author: wangyan
 * @date: 2023/9/14 19:24
 */
public class StandardValeUtils {


    public static List<DictionaryValue> valuesConvert(String values) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            List<DictionaryValue> dictionaryValues = objectMapper.readValue(values, new TypeReference<List<DictionaryValue>>() {
            });
            return dictionaryValues;

        } catch (Exception e) {

        }
        return new ArrayList<>();
    }

    public static Map<String, Map<String,String>> langConvert(String lang) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            Map<String, Map<String,String>> langMap = objectMapper.readValue(lang, new TypeReference<Map<String, Map<String,String>>>() {
            });
            return langMap;

        } catch (Exception e) {

        }
        return new HashMap<>();
    }

    public static List<StandardDictionaryVO> queryResultConvert(List<StandardDictionaryPO> standardDictionaryPOS) {
        List<StandardDictionaryVO> list = new ArrayList<>();
        for (StandardDictionaryPO temp: standardDictionaryPOS) {
            StandardDictionaryVO standardDictionaryVO = getStandardDictionaryVO(temp);

            list.add(standardDictionaryVO);
        }
        return list;

    }

    public static StandardDictionaryVO getStandardDictionaryVO(StandardDictionaryPO standardDictionaryPO) {
        StandardDictionaryVO standardDictionaryVO = new StandardDictionaryVO();
        standardDictionaryVO.setId(standardDictionaryPO.getId());
        standardDictionaryVO.setKey(standardDictionaryPO.getKey());
        standardDictionaryVO.setDescription(standardDictionaryPO.getDescription());
        standardDictionaryVO.setStandard(standardDictionaryPO.getStandard());
        standardDictionaryVO.setApplication(standardDictionaryPO.getApplication());
        standardDictionaryVO.setCreateBy(standardDictionaryPO.getCreateBy());
        standardDictionaryVO.setCreateTime(standardDictionaryPO.getCreateTime());
        standardDictionaryVO.setEditBy(standardDictionaryPO.getEditBy());
        standardDictionaryVO.setEditTime(standardDictionaryPO.getEditTime());
        standardDictionaryVO.setTenantId(standardDictionaryPO.getTenantId());
        standardDictionaryVO.setEnumKey(standardDictionaryPO.getEnumKey());
        standardDictionaryVO.setAuditStatus(standardDictionaryPO.getAuditStatus());

        standardDictionaryVO.setValues(valuesConvert(standardDictionaryPO.getValues()));
        standardDictionaryVO.setLang(langConvert(standardDictionaryPO.getLang()));
        return standardDictionaryVO;
    }


    public static String getEnumKeyByTenant(String dictionaryKey, String tenantId) {
        // 兼容老的逻辑，我们使用 enumKey 去做为 tenantId-key，  应用开发租户(athenaDev)的应用enumKey就是本身的key
        if ("athenaDev".equals(tenantId)) {
            return dictionaryKey;
        } else {
            return tenantId + "-" + dictionaryKey;
        }
    }
}
