package com.digiwin.athena.controller;

import com.digiwin.athena.auth.annotation.FuncAuth;
import com.digiwin.athena.dto.DataStandardBusinessDto;
import com.digiwin.athena.dto.DeployDataDto;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.publish.Publish;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/dataStandard/d")
@Tag(name = "设计时数据标准",description = "9ba25fa1-1785-47f5-aae7-ec6225f0f281")
public class DDataStandardController {

    @Autowired
    @Qualifier("dataStandardPublish")
    private Publish<DataStandardBusinessDto> publish;

    @GetMapping("/publish")
    @Operation(summary = "发布当前租户下下拉词汇数据")
    @FuncAuth(resourceType = "dataStandard", resourceId = "Var:$tenantId", actions = (":*"))
    public ResultDto<Boolean> publishTenantData(){
        List<DataStandardBusinessDto> allPublishData = publish.findAllPublishData(null);

        DeployDataDto<DataStandardBusinessDto> dataDto = new DeployDataDto<>();
        dataDto.setPublishData(allPublishData);

        publish.publishAll(dataDto);
        return ResultDto.createSuccess(true);
    }
}
