package com.digiwin.athena.domain;

import com.digiwin.athena.domain.dictionary.DictionaryValue;
import com.digiwin.athena.utils.StandardValeUtils;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Data
@Document(collection = "tStandardDictionary")
@NoArgsConstructor
@AllArgsConstructor
public class StandardDictionaryPO {
    @Id
    private String id;
    // 枚举key
//    @TableField(value="dictionary_key")
//    @JSONField(name= "dictionary_key")
    private String key;
    // 枚举key的描述
    private String description;
    // key对应的value
//    @TableField(value="dictionary_values")
//    @JSONField(name= "dictionary_values")
    private String values;
    // 应用code
    private String application;
    // "Y/N" -- 标准(是/否)
    private String standard;
    // 是tenantId_key的组合
    private String enumKey;
    // 多语言
    private String lang;

    //审核状态// 1 非标无需审核，2 待审核，3 已审核
    private String auditStatus;

    private Long systemId;

    private String tenantId;

    private String teamId;

    private Date editTime;

    private String editBy;

    private Date createTime;

    private String createBy;

    public List<RuntimeDictionary> convertRuntimeDictionary(){
        ArrayList<RuntimeDictionary> res = new ArrayList<>();

        List<DictionaryValue> valueList = StandardValeUtils.valuesConvert(this.values);
        if (!valueList.isEmpty()){
            for (DictionaryValue dictionaryValue : valueList) {
                RuntimeDictionary runtimeDictionary = new RuntimeDictionary();
                res.add(runtimeDictionary);
                runtimeDictionary.setCode(dictionaryValue.getCode());
                runtimeDictionary.setValue(dictionaryValue.getValue());
                runtimeDictionary.setDesc(dictionaryValue.getDesc());
                runtimeDictionary.setTenantId(this.tenantId);
                runtimeDictionary.setLang(dictionaryValue.getLang());
                runtimeDictionary.setKey(this.enumKey);
            }
        }
        return res;
    }
}
