package com.digiwin.athena.domain.dictionary;

import java.util.HashMap;
import java.util.Map;

public class DictionaryTitle {
    private String value;
    private String title;
    private Map<String, Map<String, String>> lang;

    public static DictionaryTitle create(DictionaryValue dictionaryValue){
        DictionaryTitle dictionaryTitle = new DictionaryTitle();
        dictionaryTitle.title = dictionaryValue.getValue();
        dictionaryTitle.value = dictionaryValue.getCode();

        HashMap<String, Map<String, String>> lang = new HashMap<>();
        for (Map.Entry<String, Map<String, String>> entry : dictionaryValue.getLang().entrySet()) {
            lang.put("title",entry.getValue());
        }

        dictionaryTitle.lang = lang;

        return dictionaryTitle;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Map<String, Map<String, String>> getLang() {
        return lang;
    }

    public void setLang(Map<String, Map<String, String>> lang) {
        this.lang = lang;
    }
}
