package com.digiwin.athena.publish;

import com.digiwin.athena.dao.StandardDictionaryMongoDao;
import com.digiwin.athena.domain.StandardDictionaryPO;
import com.digiwin.athena.dto.DataStandardBusinessDto;
import com.digiwin.athena.publish.dto.PublishParam;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service("dataStandardExtendWrapper")
@Slf4j
@ConditionalOnProperty(name = "system_env",havingValue = "FenXiao")
public class FxDataStandardExtendWrapper extends PublishExtendOperationWrapper<DataStandardBusinessDto>{
    @Autowired
    private StandardDictionaryMongoDao standardDictionaryMongoDao;

    @Override
    public List<DataStandardBusinessDto> findAllPublishData(PublishParam publishParam) {
        //数据字典发布，按照租户发
        List<StandardDictionaryPO> standardDictionaryPOS = standardDictionaryMongoDao.selectByTenantId(CurThreadInfoUtils.getCurTokenTenant().getTenantId());
        List<DataStandardBusinessDto> res = standardDictionaryPOS.stream().map(s -> {
            DataStandardBusinessDto dataStandardBusinessDto = new DataStandardBusinessDto();
            dataStandardBusinessDto.setStandardDictionaryPO(s);
            return dataStandardBusinessDto;
        }).collect(Collectors.toList());

        return res;
    }
}
