package com.digiwin.athena.domain;

import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Map;

/**
 * <Description> <br>
 *
 * @author wang.xinyuan<br>
 * @version 1.0<br>
 * @CreateDate 2023/7/7 <br>
 */
@Data
@Accessors(chain = true)
@Document(collection = "dictionary")
public class RuntimeDictionary {
    @Id
    private String objectId;
    // 枚举key
    private String key;
    private String code;
    private String value;
    private String desc;
    private String application;
    private Map<String, Map<String, String>> lang;
    private String tenantId;
}