package com.digiwin.athena.domain.dictionary;

import com.digiwin.athena.mongodb.MongoBaseDto;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;
import java.util.Map;

@Data
@Document(collection = "dictionary")
@Accessors(chain = true)
public class Dictionary extends MongoBaseDto {
    @Id
    private String objectId;
    // 枚举key
    private String key;
    // 枚举key的描述
    private String description;
    // key对应的value
    private List<DictionaryValue> values;
    private String application;
    private Map<String, Map<String,String>> lang;
}
