package com.digiwin.athena.publish;

import com.digiwin.athena.dao.RuntimeDictionaryMongoDao;
import com.digiwin.athena.dao.StandardDictionaryMongoDao;
import com.digiwin.athena.domain.DeployDetail;
import com.digiwin.athena.domain.RuntimeDictionary;
import com.digiwin.athena.domain.StandardDictionaryPO;
import com.digiwin.athena.dto.DataStandardBusinessDto;
import com.digiwin.athena.dto.DeployDataDto;
import com.digiwin.athena.dto.TenantInfo;
import com.digiwin.athena.publish.dto.PublishParam;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

@Component
@Slf4j
@Order(1)
public class DataStandardPublish extends Publish<DataStandardBusinessDto>{

    @Autowired
    private RuntimeDictionaryMongoDao runtimeDictionaryMongoDao;

    @Autowired
    @Qualifier("dataStandardExtendWrapper")
    private PublishExtendOperationWrapper<DataStandardBusinessDto> publishExtendOperationWrapper;

    @Override
    public List<DataStandardBusinessDto> doCompile(List<DataStandardBusinessDto> data) {
        return data;
    }

    @Override
    void deleteRuntimeData(DeployDataDto<DataStandardBusinessDto> deployDataDto) {
        //按照租户删除运行时数据
        TenantInfo curTokenTenant = CurThreadInfoUtils.getCurTokenTenant();
        runtimeDictionaryMongoDao.deleteByTenantId(curTokenTenant.getTenantId());
    }

    @Override
    public List<DataStandardBusinessDto> findAllPublishData(PublishParam publishParam) {

        return publishExtendOperationWrapper.findAllPublishData(publishParam);
    }

    @Override
    public void startPreHandle(DeployDataDto<DataStandardBusinessDto> deployDataDto) {
        deleteRuntimeData(deployDataDto);
    }

    @Override
    void insertSingleRuntimeData(DataStandardBusinessDto publishData) {
        List<RuntimeDictionary> runtimeDictionaries = publishData.getStandardDictionaryPO().convertRuntimeDictionary();
        if (!runtimeDictionaries.isEmpty()){
            runtimeDictionaryMongoDao.insertAll(runtimeDictionaries);
        }

    }

    @Override
    void deleteSingleRuntimeData(DataStandardBusinessDto publishData) {

    }

    @Override
    public DataStandardBusinessDto findSinglePublishData(PublishParam publishParam) {

        return null;
    }

}
