/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.utils;

import com.digiwin.athena.domain.StandardDictionaryPO;
import com.digiwin.athena.domain.datastandard.StandardDictionaryVO;
import com.digiwin.athena.domain.dictionary.DictionaryValue;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StandardValeUtils {
    public static List<DictionaryValue> valuesConvert(String values) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            List dictionaryValues = (List)objectMapper.readValue(values, (TypeReference)new TypeReference<List<DictionaryValue>>(){});
            return dictionaryValues;
        }
        catch (Exception exception) {
            return new ArrayList<DictionaryValue>();
        }
    }

    public static Map<String, Map<String, String>> langConvert(String lang) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            Map langMap = (Map)objectMapper.readValue(lang, (TypeReference)new TypeReference<Map<String, Map<String, String>>>(){});
            return langMap;
        }
        catch (Exception exception) {
            return new HashMap<String, Map<String, String>>();
        }
    }

    public static List<StandardDictionaryVO> queryResultConvert(List<StandardDictionaryPO> standardDictionaryPOS) {
        ArrayList<StandardDictionaryVO> list = new ArrayList<StandardDictionaryVO>();
        for (StandardDictionaryPO temp : standardDictionaryPOS) {
            StandardDictionaryVO standardDictionaryVO = StandardValeUtils.getStandardDictionaryVO(temp);
            list.add(standardDictionaryVO);
        }
        return list;
    }

    public static StandardDictionaryVO getStandardDictionaryVO(StandardDictionaryPO standardDictionaryPO) {
        StandardDictionaryVO standardDictionaryVO = new StandardDictionaryVO();
        standardDictionaryVO.setId(standardDictionaryPO.getId());
        standardDictionaryVO.setKey(standardDictionaryPO.getKey());
        standardDictionaryVO.setDescription(standardDictionaryPO.getDescription());
        standardDictionaryVO.setStandard(standardDictionaryPO.getStandard());
        standardDictionaryVO.setApplication(standardDictionaryPO.getApplication());
        standardDictionaryVO.setCreateBy(standardDictionaryPO.getCreateBy());
        standardDictionaryVO.setCreateTime(standardDictionaryPO.getCreateTime());
        standardDictionaryVO.setEditBy(standardDictionaryPO.getEditBy());
        standardDictionaryVO.setEditTime(standardDictionaryPO.getEditTime());
        standardDictionaryVO.setTenantId(standardDictionaryPO.getTenantId());
        standardDictionaryVO.setEnumKey(standardDictionaryPO.getEnumKey());
        standardDictionaryVO.setAuditStatus(standardDictionaryPO.getAuditStatus());
        standardDictionaryVO.setValues(StandardValeUtils.valuesConvert(standardDictionaryPO.getValues()));
        standardDictionaryVO.setLang(StandardValeUtils.langConvert(standardDictionaryPO.getLang()));
        return standardDictionaryVO;
    }

    public static String getEnumKeyByTenant(String dictionaryKey, String tenantId) {
        if ("athenaDev".equals(tenantId)) {
            return dictionaryKey;
        }
        return tenantId + "-" + dictionaryKey;
    }
}

