/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.athena.domain.WordDictionaryManagePO;
import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Repository;

@Repository
public class WordDictionaryMongoDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WordDictionaryMongoDao.class);
    @Resource
    private MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;
    private final MongoTemplate mongoTemplate;

    @Autowired
    public WordDictionaryMongoDao(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public void insert(List<WordDictionaryManagePO> standardDictionaryPOList) {
        this.mongoSystemRepositoryDecorator.insertAll(standardDictionaryPOList);
    }

    public void update(WordDictionaryManagePO standardDictionaryPO) {
        this.mongoSystemRepositoryDecorator.save((Object)standardDictionaryPO);
    }

    public long count(String id) {
        return this.mongoSystemRepositoryDecorator.count(new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id)), WordDictionaryManagePO.class);
    }

    public List<Map<String, Object>> queryByDataName(List<String> dataNames) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)Criteria.where((String)"dataName").in(dataNames)), Aggregation.lookup((String)"tStandardBusinessType", (String)"relateBusinessTypeId", (String)"id", (String)"businessTypeData"), Aggregation.unwind((String)"businessTypeData", (boolean)true), Aggregation.lookup((String)"tStandardDictionary", (String)"relateDictionaryId", (String)"id", (String)"dictionaryData"), Aggregation.unwind((String)"dictionaryData", (boolean)true), Aggregation.project((String[])new String[0]).and("id").as("id").and("dataName").as("dataName").and("descriptionZhTw").as("descriptionZhTw").and("descriptionZhCn").as("descriptionZhCn").and("descriptionEnUs").as("descriptionEnUs").and("typeZhTw").as("typeZhTw").and("typeZhCn").as("typeZhCn").and("typeEnUs").as("typeEnUs").and("unitOrDefaultZhTw").as("unitOrDefaultZhTw").and("unitOrDefaultZhCn").as("unitOrDefaultZhCn").and("unitOrDefaultEnUs").as("unitOrDefaultEnUs").and("tagZhTw").as("tagZhTw").and("tagZhCn").as("tagZhCn").and("tagEnUs").as("tagEnUs").and("remarkZhTw").as("remarkZhTw").and("remarkZhCn").as("remarkZhCn").and("remarkEnUs").as("remarkEnUs").and("approvedStatus").as("approvedStatus").and("buildAcct").as("buildAcct").and("buildTime").as("buildTime").and("approvedAcct").as("approvedAcct").and("approvedTime").as("approvedTime").and("lastUpdateTime").as("lastUpdateTime").and("dirty").as("dirty").and("relateBusinessTypeId").as("relateBusinessTypeId").and("relateDictionaryId").as("relateDictionaryId").and("likenessWord").as("likenessWord").and("standard").as("standard").and("manageStatus").as("manageStatus").and("auditStatus").as("auditStatus").and("systemId").as("systemId").and("tenantId").as("tenantId").and("teamId").as("teamId").and("editTime").as("editTime").and("editBy").as("editBy").and("createTime").as("createTime").and("createBy").as("createBy").and("businessTypeData.code").as("businessCode").and("businessTypeData.name").as("businessType").and("businessTypeData.dataType").as("businessDataType").and("businessTypeData.size").as("businessSize").and("businessTypeData.fieldPrecision").as("businessPrecision").and("dictionaryData.dictionaryKey").as("dictionaryKey").and("dictionaryData.description").as("dictionaryDesc").and("dictionaryData.dictionaryValues").as("dictionaryValues")});
        List documentList = this.mongoTemplate.aggregate(aggregation, "tStandardWordDictionary", Document.class).getMappedResults();
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (Document document : documentList) {
            HashMap map = new HashMap(document);
            resultList.add(map);
        }
        return resultList;
    }

    public List<Map<String, Object>> selectWordDictionaryPage(Map<String, Object> columnMap) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.lookup((String)"tStandardBusinessType", (String)"relateBusinessTypeId", (String)"id", (String)"businessType"), Aggregation.lookup((String)"tStandardDictionary", (String)"relateDictionaryId", (String)"id", (String)"dictionary"), Aggregation.match((Criteria)this.buildMatchCriteria(columnMap)), Aggregation.project((String[])new String[0]).and("dataName").as("dataName").and("descriptionZhCn").as("descriptionZhCn"), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"editTime", "id"}), Aggregation.skip((long)this.getSkip(columnMap)), Aggregation.limit((long)this.getLimit(columnMap))});
        List documentList = this.mongoTemplate.aggregate(aggregation, "tStandardWordDictionary", Document.class).getMappedResults();
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (Document document : documentList) {
            HashMap map = new HashMap(document);
            resultList.add(map);
        }
        return resultList;
    }

    private Criteria buildMatchCriteria(Map<String, Object> columnMap) {
        Criteria criteria = Criteria.where((String)"1").is((Object)"1");
        if (columnMap.get("sourcePage") != null && "modelDriven".equals(columnMap.get("sourcePage"))) {
            if ((Integer)columnMap.get("isBM") == 1) {
                criteria = criteria.and("standard").is((Object)"Y").and("manageStatus").is((Object)"Y");
            } else if ((Integer)columnMap.get("isBM") == 0) {
                criteria = criteria.and(String.valueOf(Criteria.where((String)"tenantId").is(columnMap.get("tenantId")).orOperator(new Criteria[]{Criteria.where((String)"standard").is((Object)"Y").and("manageStatus").is((Object)"Y")})));
            }
        } else if ((Integer)columnMap.get("hasAuth") == 0 && columnMap.get("standard") != null && !"".equals(columnMap.get("standard"))) {
            criteria = criteria.and(String.valueOf(Criteria.where((String)"tenantId").is(columnMap.get("tenantId")).orOperator(new Criteria[]{Criteria.where((String)"standard").is((Object)"Y").and("manageStatus").is((Object)"Y")}))).and("standard").is(columnMap.get("standard"));
        } else if ((Integer)columnMap.get("hasAuth") == 0 && (columnMap.get("standard") == null || "".equals(columnMap.get("standard")))) {
            criteria = criteria.and(String.valueOf(Criteria.where((String)"tenantId").is(columnMap.get("tenantId")).orOperator(new Criteria[]{Criteria.where((String)"standard").is((Object)"Y").and("manageStatus").is((Object)"Y")})));
        } else if ((Integer)columnMap.get("hasAuth") == 1 && columnMap.get("standard") != null && !"".equals(columnMap.get("standard"))) {
            criteria = criteria.and("standard").is(columnMap.get("standard"));
        }
        if (columnMap.get("keyword") != null && !"".equals(columnMap.get("keyword"))) {
            criteria = criteria.and(String.valueOf(Criteria.where((String)"dataName").regex(".*" + columnMap.get("keyword") + ".*").orOperator(new Criteria[]{Criteria.where((String)"descriptionZhCn").regex(".*" + columnMap.get("keyword") + ".*"), Criteria.where((String)"descriptionEnUs").regex(".*" + columnMap.get("keyword") + ".*"), Criteria.where((String)"descriptionZhTw").regex(".*" + columnMap.get("keyword") + ".*"), Criteria.where((String)"likenessWord").regex(".*" + columnMap.get("keyword") + ".*")})));
        }
        return criteria;
    }

    private long getSkip(Map<String, Object> columnMap) {
        Integer pageNum = (Integer)columnMap.get("pageNum");
        Integer pageSize = (Integer)columnMap.get("pageSize");
        if (pageNum != null && pageSize != null) {
            return (pageNum - 1) * pageSize;
        }
        return 0L;
    }

    private long getLimit(Map<String, Object> columnMap) {
        Integer pageSize = (Integer)columnMap.get("pageSize");
        if (pageSize != null) {
            return pageSize.intValue();
        }
        return 0L;
    }

    public Integer selectCountNum(Map<String, Object> columnMap) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)this.buildMatchCriteria1(columnMap)), Aggregation.count().as("count")});
        List documentList = this.mongoTemplate.aggregate(aggregation, "tStandardWordDictionary", Document.class).getMappedResults();
        ArrayList resultList = new ArrayList();
        for (Document document : documentList) {
            HashMap map = new HashMap(document);
            resultList.add(map);
        }
        if (resultList.isEmpty()) {
            return 0;
        }
        return ((Number)((Map)resultList.get(0)).get("count")).intValue();
    }

    private Criteria buildMatchCriteria1(Map<String, Object> columnMap) {
        Criteria criteria = Criteria.where((String)"1").is((Object)"1");
        if (columnMap.get("sourcePage") != null && "modelDriven".equals(columnMap.get("sourcePage"))) {
            if ((Integer)columnMap.get("hasAuth") == 1) {
                criteria = criteria.and("standard").is((Object)"Y").and("manageStatus").is((Object)"Y");
            } else if ((Integer)columnMap.get("hasAuth") == 0) {
                criteria = criteria.and(String.valueOf(Criteria.where((String)"tenantId").is(columnMap.get("tenantId")).orOperator(new Criteria[]{Criteria.where((String)"standard").is((Object)"Y").and("manageStatus").is((Object)"Y")})));
            }
        } else if ((Integer)columnMap.get("hasAuth") == 0 && columnMap.get("standard") != null && !"".equals(columnMap.get("standard"))) {
            criteria = criteria.and(String.valueOf(Criteria.where((String)"tenantId").is(columnMap.get("tenantId")).orOperator(new Criteria[]{Criteria.where((String)"standard").is((Object)"Y").and("manageStatus").is((Object)"Y")}))).and("standard").is(columnMap.get("standard"));
        } else if ((Integer)columnMap.get("hasAuth") == 0 && (columnMap.get("standard") == null || "".equals(columnMap.get("standard")))) {
            criteria = criteria.and(String.valueOf(Criteria.where((String)"tenantId").is(columnMap.get("tenantId")).orOperator(new Criteria[]{Criteria.where((String)"standard").is((Object)"Y").and("manageStatus").is((Object)"Y")})));
        } else if ((Integer)columnMap.get("hasAuth") == 1 && columnMap.get("standard") != null && !"".equals(columnMap.get("standard"))) {
            criteria = criteria.and("standard").is(columnMap.get("standard"));
        }
        if (columnMap.get("keyword") != null && !"".equals(columnMap.get("keyword"))) {
            criteria = criteria.and(String.valueOf(Criteria.where((String)"dataName").regex(".*" + columnMap.get("keyword") + ".*").orOperator(new Criteria[]{Criteria.where((String)"descriptionEnUs").regex(".*" + columnMap.get("keyword") + ".*"), Criteria.where((String)"descriptionZhCn").regex(".*" + columnMap.get("keyword") + ".*"), Criteria.where((String)"descriptionZhTw").regex(".*" + columnMap.get("keyword") + ".*"), Criteria.where((String)"likenessWord").regex(".*" + columnMap.get("keyword") + ".*")})));
        }
        return criteria;
    }

    public List<Map<String, Object>> queryModelDrivenInnerISV(Page<WordDictionaryManagePO> page, List<String> teamIds, String auditStatus, String keyWord) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.lookup((String)"tStandardBusinessType", (String)"relateBusinessTypeId", (String)"id", (String)"businessType"), Aggregation.lookup((String)"tStandardDictionary", (String)"relateDictionaryId", (String)"id", (String)"dictionary"), Aggregation.match((Criteria)this.buildMatchCriteria(teamIds, auditStatus, keyWord)), Aggregation.project((String[])new String[0]).and("dataName").as("dataName").and("descriptionZhTw").as("descriptionZhTw").and("descriptionZhCn").as("descriptionZhCn").and("descriptionEnUs").as("descriptionEnUs").and("relateBusinessTypeId").as("relateBusinessTypeId").and("relateDictionaryId").as("relateDictionaryId").and("editBy").as("editBy").and("editTime").as("editTime").and("createTime").as("createTime").and("createBy").as("createBy").and("tenantId").as("tenantId").and("manageStatus").as("manageStatus").and("likenessWord").as("likenessWord").and("id").as("id").and("standard").as("standard").and("teamId").as("teamId").and("auditStatus").as("auditStatus").and("businessType.code").as("bizCode").and("businessType.name").as("bizName").and("businessType.dataType").as("dataType").and("businessType.size").as("size").and("businessType.fieldPrecision").as("fieldPrecision").and("dictionary.dictionaryKey").as("dictionaryKey").and("dictionary.dictionaryValues").as("dictionaryValues"), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"editTime"}), Aggregation.skip((long)((page.getPages() - 1L) * page.getSize())), Aggregation.limit((long)page.getSize())});
        List documentList = this.mongoTemplate.aggregate(aggregation, "tStandardWordDictionary", Document.class).getMappedResults();
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (Document document : documentList) {
            HashMap map = new HashMap(document);
            resultList.add(map);
        }
        return resultList;
    }

    private Criteria buildMatchCriteria(List<String> teamIds, String auditStatus, String keyWord) {
        Criteria criteria = Criteria.where((String)"teamId").in(teamIds);
        criteria = criteria.and(String.valueOf(Criteria.where((String)"standard").is((Object)"N").orOperator(new Criteria[]{Criteria.where((String)"standard").is((Object)"Y").and("manageStatus").is((Object)"Y").and("auditStatus").is((Object)auditStatus)})));
        if (keyWord != null && !keyWord.isEmpty()) {
            criteria = criteria.and(String.valueOf(Criteria.where((String)"dataName").regex(".*" + keyWord + ".*").orOperator(new Criteria[]{Criteria.where((String)"descriptionEnUs").regex(".*" + keyWord + ".*"), Criteria.where((String)"descriptionZhCn").regex(".*" + keyWord + ".*"), Criteria.where((String)"descriptionZhTw").regex(".*" + keyWord + ".*"), Criteria.where((String)"likenessWord").regex(".*" + keyWord + ".*")})));
        }
        return criteria;
    }

    public List<Map<String, Object>> queryModelDrivenOuterISV(Page<WordDictionaryManagePO> page, String tenantId, List<String> teamIds, String auditStatus, String keyWord) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.lookup((String)"tStandardBusinessType", (String)"relateBusinessTypeId", (String)"id", (String)"businessType"), Aggregation.lookup((String)"tStandardDictionary", (String)"relateDictionaryId", (String)"id", (String)"dictionary"), Aggregation.match((Criteria)this.buildMatchCriteria(tenantId, teamIds, auditStatus, keyWord)), Aggregation.project((String[])new String[0]).and("dataName").as("dataName").and("descriptionZhTw").as("descriptionZhTw").and("descriptionZhCn").as("descriptionZhCn").and("descriptionEnUs").as("descriptionEnUs").and("relateBusinessTypeId").as("relateBusinessTypeId").and("relateDictionaryId").as("relateDictionaryId").and("editBy").as("editBy").and("editTime").as("editTime").and("createTime").as("createTime").and("createBy").as("createBy").and("tenantId").as("tenantId").and("manageStatus").as("manageStatus").and("likenessWord").as("likenessWord").and("id").as("id").and("standard").as("standard").and("teamId").as("teamId").and("auditStatus").as("auditStatus").and("businessType.code").as("bizCode").and("businessType.name").as("bizName").and("businessType.dataType").as("dataType").and("businessType.size").as("size").and("businessType.fieldPrecision").as("fieldPrecision").and("dictionary.dictionaryKey").as("dictionaryKey").and("dictionary.dictionaryValues").as("dictionaryValues"), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"editTime"}), Aggregation.skip((long)((page.getPages() - 1L) * page.getSize())), Aggregation.limit((long)page.getSize())});
        List documentList = this.mongoTemplate.aggregate(aggregation, "tStandardWordDictionary", Document.class).getMappedResults();
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (Document document : documentList) {
            HashMap map = new HashMap(document);
            resultList.add(map);
        }
        return resultList;
    }

    private Criteria buildMatchCriteria(String tenantId, List<String> teamIds, String auditStatus, String keyWord) {
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId).and(String.valueOf(Criteria.where((String)"standard").is((Object)"N").orOperator(new Criteria[]{Criteria.where((String)"standard").is((Object)"Y").and("manageStatus").is((Object)"Y").and("auditStatus").is((Object)auditStatus)}))).orOperator(new Criteria[]{Criteria.where((String)"teamId").in(teamIds).and("manageStatus").is((Object)"Y").and("standard").is((Object)"Y").and("auditStatus").is((Object)auditStatus)});
        if (keyWord != null && !keyWord.isEmpty()) {
            criteria = criteria.and(String.valueOf(Criteria.where((String)"dataName").regex(".*" + keyWord + ".*").orOperator(new Criteria[]{Criteria.where((String)"descriptionEnUs").regex(".*" + keyWord + ".*"), Criteria.where((String)"descriptionZhCn").regex(".*" + keyWord + ".*"), Criteria.where((String)"descriptionZhTw").regex(".*" + keyWord + ".*"), Criteria.where((String)"likenessWord").regex(".*" + keyWord + ".*")})));
        }
        return criteria;
    }

    public List<Map<String, Object>> queryInnerISV(Page<WordDictionaryManagePO> page, List<String> teamIds, String auditStatus, String keyWord, String standard) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.lookup((String)"tStandardBusinessType", (String)"relateBusinessTypeId", (String)"id", (String)"businessType"), Aggregation.lookup((String)"tStandardDictionary", (String)"relateDictionaryId", (String)"id", (String)"dictionary"), Aggregation.match((Criteria)this.buildMatchCriteria(teamIds, auditStatus, keyWord, standard)), Aggregation.project((String[])new String[0]).and("dataName").as("dataName").and("descriptionZhTw").as("descriptionZhTw").and("descriptionZhCn").as("descriptionZhCn").and("descriptionEnUs").as("descriptionEnUs").and("relateBusinessTypeId").as("relateBusinessTypeId").and("relateDictionaryId").as("relateDictionaryId").and("editBy").as("editBy").and("editTime").as("editTime").and("createTime").as("createTime").and("createBy").as("createBy").and("tenantId").as("tenantId").and("manageStatus").as("manageStatus").and("likenessWord").as("likenessWord").and("id").as("id").and("standard").as("standard").and("teamId").as("teamId").and("auditStatus").as("auditStatus").and("businessType.code").as("bizCode").and("businessType.name").as("bizName").and("businessType.dataType").as("dataType").and("businessType.size").as("size").and("businessType.fieldPrecision").as("fieldPrecision").and("dictionary.dictionaryKey").as("dictionaryKey").and("dictionary.dictionaryValues").as("dictionaryValues"), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"editTime"}), Aggregation.skip((long)((page.getPages() - 1L) * page.getSize())), Aggregation.limit((long)page.getSize())});
        List documentList = this.mongoTemplate.aggregate(aggregation, "tStandardWordDictionary", Document.class).getMappedResults();
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (Document document : documentList) {
            HashMap map = new HashMap(document);
            resultList.add(map);
        }
        return resultList;
    }

    private Criteria buildMatchCriteria(List<String> teamIds, String auditStatus, String keyWord, String standard) {
        Criteria criteria = Criteria.where((String)"teamId").in(teamIds);
        if (auditStatus != null && !"".equals(auditStatus)) {
            criteria = criteria.and("auditStatus").is((Object)auditStatus);
        }
        if (standard != null && !"".equals(standard)) {
            criteria = criteria.and("standard").is((Object)standard);
        }
        if (keyWord != null && !"".equals(keyWord)) {
            criteria = criteria.and(String.valueOf(Criteria.where((String)"dataName").regex(".*" + keyWord + ".*").orOperator(new Criteria[]{Criteria.where((String)"descriptionEnUs").regex(".*" + keyWord + ".*"), Criteria.where((String)"descriptionZhCn").regex(".*" + keyWord + ".*"), Criteria.where((String)"descriptionZhTw").regex(".*" + keyWord + ".*"), Criteria.where((String)"likenessWord").regex(".*" + keyWord + ".*")})));
        }
        return criteria;
    }

    public List<Map<String, Object>> queryOuterISV(Page<WordDictionaryManagePO> page, String tenantId, List<String> teamIds, String auditStatus, String keyWord, String standard) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.lookup((String)"tStandardBusinessType", (String)"relateBusinessTypeId", (String)"id", (String)"businessType"), Aggregation.lookup((String)"tStandardDictionary", (String)"relateDictionaryId", (String)"id", (String)"dictionary"), Aggregation.match((Criteria)this.buildMatchCriteria(tenantId, teamIds, auditStatus, keyWord, standard)), Aggregation.project((String[])new String[0]).and("dataName").as("dataName").and("descriptionZhTw").as("descriptionZhTw").and("descriptionZhCn").as("descriptionZhCn").and("descriptionEnUs").as("descriptionEnUs").and("relateBusinessTypeId").as("relateBusinessTypeId").and("relateDictionaryId").as("relateDictionaryId").and("editBy").as("editBy").and("editTime").as("editTime").and("createTime").as("createTime").and("createBy").as("createBy").and("tenantId").as("tenantId").and("manageStatus").as("manageStatus").and("likenessWord").as("likenessWord").and("id").as("id").and("standard").as("standard").and("teamId").as("teamId").and("auditStatus").as("auditStatus").and("businessType.code").as("bizCode").and("businessType.name").as("bizName").and("businessType.dataType").as("dataType").and("businessType.size").as("size").and("businessType.fieldPrecision").as("fieldPrecision").and("dictionary.dictionaryKey").as("dictionaryKey").and("dictionary.dictionaryValues").as("dictionaryValues"), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"editTime"}), Aggregation.skip((long)((page.getPages() - 1L) * page.getSize())), Aggregation.limit((long)page.getSize())});
        List documentList = this.mongoTemplate.aggregate(aggregation, "tStandardWordDictionary", Document.class).getMappedResults();
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (Document document : documentList) {
            HashMap map = new HashMap(document);
            resultList.add(map);
        }
        return resultList;
    }

    private Criteria buildMatchCriteria(String tenantId, List<String> teamIds, String auditStatus, String keyWord, String standard) {
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId);
        if (auditStatus != null && !"".equals(auditStatus)) {
            criteria = criteria.and("auditStatus").is((Object)auditStatus);
        }
        if (standard != null && !"".equals(standard)) {
            criteria = criteria.and("standard").is((Object)standard);
        }
        if ("2".equals(auditStatus) || teamIds != null && !teamIds.isEmpty()) {
            criteria = criteria.and("teamId").in(teamIds).and("manageStatus").is((Object)"Y");
        }
        criteria = auditStatus == null || "".equals(auditStatus) ? criteria.and("auditStatus").is((Object)"3") : criteria.and("auditStatus").is((Object)auditStatus);
        criteria = standard == null || "".equals(standard) || "Y".equals(standard) ? criteria.and("standard").is((Object)"Y") : criteria.and("standard").is((Object)"Q");
        if (keyWord != null && !"".equals(keyWord)) {
            criteria = criteria.and(String.valueOf(Criteria.where((String)"dataName").regex(".*" + keyWord + ".*").orOperator(new Criteria[]{Criteria.where((String)"descriptionEnUs").regex(".*" + keyWord + ".*"), Criteria.where((String)"descriptionZhCn").regex(".*" + keyWord + ".*"), Criteria.where((String)"descriptionZhTw").regex(".*" + keyWord + ".*"), Criteria.where((String)"likenessWord").regex(".*" + keyWord + ".*")})));
        }
        return criteria;
    }

    public void updateTeamId(String teamId, String id) {
        Criteria criteria = Criteria.where((String)"id").is((Object)id);
        Update update = new Update().set("teamId", (Object)teamId);
        this.mongoTemplate.updateFirst(Query.query((CriteriaDefinition)criteria), (UpdateDefinition)update, "tStandardWordDictionary");
    }

    public List<WordDictionaryManagePO> selectByCode(List<String> codes) {
        Criteria criteria = Criteria.where((String)"code").in(codes);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoSystemRepositoryDecorator.find(query, WordDictionaryManagePO.class);
    }

    public List<WordDictionaryManagePO> selectAll() {
        return this.mongoSystemRepositoryDecorator.findAll(WordDictionaryManagePO.class);
    }

    public List<String> selectAllTenantId() {
        return this.mongoSystemRepositoryDecorator.findAll(WordDictionaryManagePO.class).stream().map(WordDictionaryManagePO::getTenantId).toList();
    }

    public List<WordDictionaryManagePO> selectByTenantId(String tenantId) {
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoSystemRepositoryDecorator.find(query, WordDictionaryManagePO.class);
    }

    public WordDictionaryManagePO selectOneByCondition(Criteria criteria) {
        Query query = new Query((CriteriaDefinition)criteria);
        return (WordDictionaryManagePO)this.mongoSystemRepositoryDecorator.findOne(query, WordDictionaryManagePO.class);
    }

    public List<WordDictionaryManagePO> selectListByCondition(Criteria criteria) {
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoSystemRepositoryDecorator.find(query, WordDictionaryManagePO.class);
    }

    public void deleteListByCondition(Criteria criteria) {
        Query query = new Query((CriteriaDefinition)criteria);
        this.mongoSystemRepositoryDecorator.delete(query, WordDictionaryManagePO.class);
    }
}

