package com.digiwin.athena.domain.dictionary;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Map;

/**
 * <Description> <br>
 *
 * @author wang.xinyuan<br>
 * @version 1.0<br>
 * @CreateDate 2023/7/7 <br>
 */
@Data
public class DictionaryValue {
    // 枚举值
    @Schema(name = "code", description = "下拉辞汇的编码")
    private String code;
    // 枚举值含义
    @Schema(name = "value", description = "下拉辞汇的值")
    private String value;
    // 枚举值含义code
    @Schema(name = "desc", description = "下拉辞汇的描述")
    private String desc;
    // 枚举值排序
    @Schema(name = "sort", description = "下拉辞汇的顺序")
    private int sort;
    @Schema(name = "lang", description = "下拉辞汇的多语言")
    private Map<String, Map<String, String>> lang;
}