/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ZipUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.dao.CompiledDataV2MongoDao;
import com.digiwin.athena.dao.DeployDetailMongoDao;
import com.digiwin.athena.dao.DeployLogMongoDao;
import com.digiwin.athena.domain.CompiledData;
import com.digiwin.athena.domain.DeployDetail;
import com.digiwin.athena.domain.DeployLog;
import com.digiwin.athena.domain.FileStore;
import com.digiwin.athena.dto.AppCompileDataResult;
import com.digiwin.athena.dto.ApplicationData;
import com.digiwin.athena.dto.CompileParam;
import com.digiwin.athena.dto.DeployBasicInfoResDto;
import com.digiwin.athena.dto.DeployDataDto;
import com.digiwin.athena.dto.DeployDetailInfoResDto;
import com.digiwin.athena.dto.DeployLogParamDto;
import com.digiwin.athena.dto.DeployLogResDto;
import com.digiwin.athena.dto.DeployParam;
import com.digiwin.athena.dto.TenantInfo;
import com.digiwin.athena.dto.UserInfoDto;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.publish.Publish;
import com.digiwin.athena.publish.dto.PublishParam;
import com.digiwin.athena.service.DeployService;
import com.digiwin.athena.service.FileStoreService;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.digiwin.athena.utils.user.UserHelper;
import io.jsonwebtoken.lang.Assert;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DeployServiceImpl
implements DeployService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployServiceImpl.class);
    @Autowired
    private DeployLogMongoDao deployLogMongoDao;
    @Autowired
    private CompiledDataV2MongoDao compiledDataV2MongoDao;
    @Autowired
    @Qualifier(value="businessTaskProcessPool")
    private ThreadPoolExecutor businessTaskProcessPool;
    @Autowired
    private List<Publish> publishList;
    @Autowired
    private FileStoreService fileStoreService;
    @Resource
    private RedissonClient redissonClient;
    @Autowired
    private DeployDetailMongoDao deployDetailMongoDao;
    public static final Map<String, Publish> publishModule = new HashMap<String, Publish>();
    private static final String DEPLOY_REDIS_KEY = "athena_designer_deployer_";

    @PostConstruct
    public void init() {
        for (Publish publish : this.publishList) {
            Class targetClass = AopUtils.getTargetClass((Object)publish);
            Order order = targetClass.getAnnotation(Order.class);
            String orderSerial = this.getOrderSerial(order.value());
            publishModule.put(orderSerial + publish.getClass().getSimpleName(), publish);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addDeployPlan(DeployParam deployParam) {
        String deployNo;
        ApplicationData applicationData;
        block5: {
            applicationData = deployParam.getApplicationData();
            CompiledData compiledData = this.compiledDataV2MongoDao.selectByCode(applicationData.getCompileDataCode());
            Assert.notNull((Object)compiledData, (String)(applicationData.getCompileDataCode() + "\u7f16\u8bd1\u5305\u4e0d\u5b58\u5728"));
            deployNo = IdUtil.fastSimpleUUID();
            DeployLog deployLog = new DeployLog();
            deployLog.setApplication(applicationData.getApplication());
            deployLog.setDeployNo(deployNo);
            deployLog.setCompileData(compiledData);
            deployLog.setType("publish");
            deployLog.setResult("waiting");
            deployLog.setDeployParam(deployParam);
            UserInfoDto userInfoDto = UserInfoDto.create();
            deployLog.setUser(userInfoDto);
            UserHelper.fillCreateInfo((Object)deployLog);
            UserHelper.fillEditInfo((Object)deployLog);
            DeployDetail deployDetail = new DeployDetail();
            deployDetail.setDeployNo(deployNo);
            deployDetail.setAdpApplication(applicationData.getApplication());
            UserHelper.fillCreateInfo((Object)deployDetail);
            UserHelper.fillEditInfo((Object)deployDetail);
            RLock lock = this.redissonClient.getLock(DEPLOY_REDIS_KEY + applicationData.getApplication());
            boolean isLock = lock.tryLock();
            try {
                if (isLock) {
                    List<DeployLog> historyDeployLogList = this.deployLogMongoDao.selectByAppAndResult(applicationData.getApplication(), Arrays.asList("waiting", "executing"));
                    if (!historyDeployLogList.isEmpty()) {
                        this.deployLogMongoDao.updateFailByApplicationAndResult(applicationData.getApplication(), Arrays.asList("waiting", "executing"));
                        List<String> deployNos = historyDeployLogList.stream().map(DeployLog::getDeployNo).collect(Collectors.toList());
                        String langStr = "{\"content\":{\"en_US\":\"Task cancellation\",\"zh_CN\":\"\u4efb\u52a1\u53d6\u6d88\",\"zh_TW\":\"\u4efb\u52d9\u53d6\u6d88\"}}";
                        this.addDeployDetail(langStr, "\u4efb\u52a1\u53d6\u6d88", "fail", deployNos, applicationData.getApplication());
                    }
                    this.deployLogMongoDao.insert(deployLog);
                    this.deployDetailMongoDao.insert(deployDetail);
                    break block5;
                }
                throw new RuntimeException("\u8be5\u5e94\u7528\u6b63\u5728\u53d1\u7248");
            }
            finally {
                lock.unlock();
            }
        }
        String branchKey = CurThreadInfoUtils.getBranchKey();
        String token = CurThreadInfoUtils.getToken();
        TenantInfo curTokenTenant = CurThreadInfoUtils.getCurTokenTenant();
        this.businessTaskProcessPool.execute(() -> {
            try {
                CurThreadInfoUtils.setBranchKey((String)branchKey);
                CurThreadInfoUtils.setToken((String)token);
                CurThreadInfoUtils.setCurTokenTenant((TenantInfo)curTokenTenant);
                this.doDeploy(deployNo, applicationData);
            }
            finally {
                CurThreadInfoUtils.removeToken();
                CurThreadInfoUtils.removeBranchKey();
                CurThreadInfoUtils.removeCurTokenTenant();
            }
        });
        return deployNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDeploy(String deployNo, ApplicationData applicationData) {
        block12: {
            File zipFile = null;
            File unZipFile = null;
            RLock lock = this.redissonClient.getLock(DEPLOY_REDIS_KEY + applicationData.getApplication());
            boolean deployLock = lock.tryLock();
            if (deployLock) {
                block11: {
                    try {
                        CompiledData compiledData = this.compiledDataV2MongoDao.selectByCode(applicationData.getCompileDataCode());
                        String contentLang = "{\"content\":{\"en_US\":\"Enter the release\",\"zh_CN\":\"\u8fdb\u5165\u53d1\u7248\",\"zh_TW\":\"\u9032\u5165\u767c\u7248\"}}";
                        this.addDeployDetail(contentLang, "\u8fdb\u5165\u53d1\u7248", "success", Arrays.asList(deployNo), applicationData.getApplication());
                        String projectDir = System.getProperty("user.dir");
                        FileStore fileStore = this.fileStoreService.getFile(compiledData.getCompiledDataFileId());
                        zipFile = new File(projectDir + File.separator + fileStore.getFileName() + "." + fileStore.getFileType());
                        unZipFile = new File(projectDir + File.separator + fileStore.getFileName());
                        FileUtil.writeBytes((byte[])fileStore.getContent(), (File)zipFile);
                        unZipFile.mkdir();
                        ZipUtil.unzip((File)zipFile, (File)unZipFile);
                        File[] dataFiles = unZipFile.listFiles();
                        for (int i = 0; i < dataFiles.length; ++i) {
                            File dataFile = dataFiles[i];
                            String originalFilename = dataFile.getName();
                            int index = originalFilename.lastIndexOf(".");
                            String name = originalFilename.substring(0, index);
                            Publish publish = publishModule.get(name);
                            List dataList = FileUtil.readLines((File)dataFile, (Charset)Charset.forName("utf-8"));
                            this.deployLogMongoDao.updateProcess(new BigDecimal((i + 1) / dataFiles.length + 1), deployNo);
                            for (String data : dataList) {
                                List list = publish.jsonStrToObject(data);
                                DeployDataDto deployDataDto = new DeployDataDto();
                                deployDataDto.setAdpApplication(applicationData.getApplication());
                                deployDataDto.setDeployNo(deployNo);
                                deployDataDto.setPublishData(list);
                                publish.publishAll(deployDataDto);
                            }
                        }
                        String langStr = "{\"content\":{\"en_US\":\"Release completed\",\"zh_CN\":\"\u53d1\u5e03\u5b8c\u6210\",\"zh_TW\":\"\u767c\u5e03\u5b8c\u6210\"}}";
                        this.addDeployDetail(langStr, "\u53d1\u5e03\u5b8c\u6210", "success", Arrays.asList(deployNo), applicationData.getApplication());
                        langStr = "{\"content\":{\"en_US\":\"Finish\",\"zh_CN\":\"\u7ed3\u675f\",\"zh_TW\":\"\u7d50\u675f\"}}";
                        this.addDeployDetail(langStr, "\u7ed3\u675f", "finish", Arrays.asList(deployNo), applicationData.getApplication());
                        this.deployLogMongoDao.updateProcessAndResult(new BigDecimal(1), "success", deployNo);
                        if (zipFile == null) break block11;
                    }
                    catch (Exception e) {
                        log.error(deployNo + "\u53d1\u5e03\u5f02\u5e38", (Throwable)e);
                        this.deployLogMongoDao.updateProcessAndResult(new BigDecimal(-1), "fail", deployNo);
                        break block12;
                    }
                    finally {
                        if (zipFile != null) {
                            FileUtil.del(zipFile);
                        }
                        if (unZipFile != null) {
                            FileUtil.del(unZipFile);
                        }
                        lock.unlock();
                    }
                    FileUtil.del((File)zipFile);
                }
                if (unZipFile != null) {
                    FileUtil.del((File)unZipFile);
                }
                lock.unlock();
            }
        }
    }

    private void addDeployDetail(String contentLang, String content, String result, List<String> deployNos, String application) {
        DeployDetail.DetailContent detailContent = new DeployDetail.DetailContent();
        detailContent.setContent(content);
        detailContent.setResult(result);
        detailContent.setTime(new Date());
        Map lang = (Map)JSONObject.parseObject((String)contentLang, (TypeReference)new TypeReference<Map<String, MultiLanguageDTO>>(){}, (Feature[])new Feature[0]);
        detailContent.setLang(lang);
        this.deployDetailMongoDao.batchUpdatePushContent(deployNos, application, detailContent);
    }

    @Override
    public String compile(CompileParam compileParam) {
        String compiledCode = IdUtil.fastSimpleUUID();
        String projectDir = System.getProperty("user.dir");
        File directory = new File(projectDir + File.separator + compiledCode);
        File zip = null;
        try {
            directory.mkdir();
            this.writeCompileData(compileParam.getApplication(), directory);
            zip = ZipUtil.zip((File)directory);
            String originalFilename = zip.getName();
            int index = originalFilename.lastIndexOf(".");
            String name = originalFilename.substring(0, index);
            String type = originalFilename.substring(index + 1);
            String fieldId = this.fileStoreService.uploadFile((InputStream)new FileInputStream(zip), name, type);
            CompiledData compiledData = compileParam.createCompiledData();
            compiledData.setCompiledDataFileId(fieldId);
            compiledData.setCode(compiledCode);
            this.compiledDataV2MongoDao.insert(compiledData);
        }
        catch (Exception e) {
            try {
                log.error("compile \u5f02\u5e38" + e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
            catch (Throwable throwable) {
                FileUtil.del((File)directory);
                if (zip != null) {
                    FileUtil.del(zip);
                }
                throw throwable;
            }
        }
        FileUtil.del((File)directory);
        if (zip != null) {
            FileUtil.del((File)zip);
        }
        return compiledCode;
    }

    @Override
    public void writeCompileData(String application, File directory) {
        for (Publish publish : this.publishList) {
            boolean created;
            Class aClass = AopUtils.getTargetClass((Object)publish);
            if (aClass.getSimpleName().equals("DataStandardPublish") && !"DATASTANDARDS".equals(application)) continue;
            PublishParam publishParam = new PublishParam();
            publishParam.setApplication(application);
            List allPublishData = publish.findAllPublishData(publishParam);
            List compiledPublishData = publish.doCompile(allPublishData);
            if (CollectionUtils.isEmpty(compiledPublishData)) continue;
            Order order = aClass.getAnnotation(Order.class);
            File file = new File(directory, this.getOrderSerial(order.value()) + aClass.getSimpleName() + ".json");
            File parentDir = file.getParentFile();
            if (!parentDir.exists() && !(created = parentDir.mkdirs())) {
                throw new RuntimeException("\u76ee\u5f55\u521b\u5efa\u5931\u8d25: " + parentDir.getAbsolutePath());
            }
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                writer.write(JSONObject.toJSONString(compiledPublishData));
            }
            catch (Exception e) {
                log.error("\u5199\u5165\u6587\u4ef6\u5f02\u5e38" + e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    @Override
    public List<AppCompileDataResult> queryCompileData(List<String> applicationList) {
        ArrayList<AppCompileDataResult> res = new ArrayList<AppCompileDataResult>();
        for (String app : applicationList) {
            List<CompiledData> compiledData = this.compiledDataV2MongoDao.selectByApplication(app);
            AppCompileDataResult appCompileDataResult = new AppCompileDataResult();
            appCompileDataResult.setCompileDataList(compiledData);
            appCompileDataResult.setApplication(app);
            res.add(appCompileDataResult);
        }
        return res;
    }

    @Override
    public List<DeployLogResDto> queryDeployLogByEnv(DeployLogParamDto deployLogParamDto) {
        DeployLog lastOne = this.deployLogMongoDao.selectLastOne(deployLogParamDto.getApplication());
        if (lastOne == null) {
            return new ArrayList<DeployLogResDto>();
        }
        DeployLog successDeployLog = this.deployLogMongoDao.selectSuccessOneByApplication(deployLogParamDto.getApplication());
        if ("executing".equals(lastOne.getResult()) || "waiting".equals(lastOne.getResult())) {
            if (successDeployLog != null) {
                DeployLogResDto res = DeployLogResDto.create(successDeployLog);
                res.setResult(lastOne.getResult());
                return Arrays.asList(res);
            }
        } else {
            if ("success".equals(lastOne.getResult())) {
                DeployLogResDto res = DeployLogResDto.create(lastOne);
                return Arrays.asList(res);
            }
            if ("fail".equals(lastOne.getResult()) && successDeployLog != null) {
                DeployLogResDto res = DeployLogResDto.create(successDeployLog);
                return Arrays.asList(res);
            }
        }
        return new ArrayList<DeployLogResDto>();
    }

    @Override
    public DeployBasicInfoResDto queryLatestDeployInfo(String application) {
        DeployLog deployLog = this.deployLogMongoDao.selectLastOne(application);
        if (deployLog == null) {
            return null;
        }
        return DeployBasicInfoResDto.create(deployLog);
    }

    @Override
    public DeployDetailInfoResDto queryDeployDetail(String deployNo, String application) {
        DeployLog deployLog = this.deployLogMongoDao.selectByDeployNoAndApp(deployNo, application);
        Assert.notNull((Object)deployLog, (String)(deployNo + "\u6ca1\u6709\u5bf9\u5e94\u7684\u53d1\u7248\u8bb0\u5f55"));
        DeployDetailInfoResDto deployDetailInfoResDto = new DeployDetailInfoResDto();
        DeployDetail deployDetail = this.deployDetailMongoDao.selectByDeployNoAndApp(deployNo, application);
        deployDetailInfoResDto.setProcess(deployLog.getProcess());
        deployDetailInfoResDto.setDetailContents(deployDetail.getContents());
        return deployDetailInfoResDto;
    }

    private String getOrderSerial(Integer order) {
        Object orderStr = order.toString();
        if (((String)orderStr).length() < 4) {
            int len = 4 - ((String)orderStr).length();
            for (int i = 0; i < len; ++i) {
                orderStr = "0" + (String)orderStr;
            }
        }
        return orderStr;
    }
}

