package com.digiwin.athena.service;

import com.digiwin.athena.dto.AppCompileDataResult;
import com.digiwin.athena.dto.CompileParam;
import com.digiwin.athena.dto.DeployBasicInfoResDto;
import com.digiwin.athena.dto.DeployDetailInfoResDto;
import com.digiwin.athena.dto.DeployLogParamDto;
import com.digiwin.athena.dto.DeployLogResDto;
import com.digiwin.athena.dto.DeployParam;

import java.io.File;
import java.util.List;

public interface DeployService {
    String addDeployPlan(DeployParam deployParam);

    String compile(CompileParam compileParam);

    DeployDetailInfoResDto queryDeployDetail(String deployNo, String application);

    void writeCompileData(String application, File directory);

    List<AppCompileDataResult> queryCompileData(List<String> applicationList);

    List<DeployLogResDto> queryDeployLogByEnv(DeployLogParamDto deployLogParamDto);

    DeployBasicInfoResDto queryLatestDeployInfo(String application);
}
