package com.digiwin.athena.domain;

import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;
import java.util.List;

@Document(collection = "compiledData")
@Data
public class CompiledData{
    @Id
    private String objectId;
    private String compiledDataFileId;
    private String designDataFileId;
    private String version;
    private List<String> versionNum;
    private String versionLetter;
    private String application;
    private String code;
    private String description;
    private Boolean allowCustomPublish;
    private Integer appType;
    private String branch;

    private String createBy;

    private Date createDate;

    private String editBy;

    private Date editDate;
}
