package com.digiwin.athena.domain;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.dto.DeployParam;
import com.digiwin.athena.dto.UserInfoDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author liyuetao
 * @title: DeployLog
 * @projectName athena_deployer
 * @description: TODO
 * @date 2022/7/1510:43
 */
@Data
@Accessors(chain = true)
@Document(collection = "deployLog")
public class DeployLog {

    public static final String PUBLISH_LOG_TYPE = "publish";
    public static final String SWITCH_LOG_TYPE = "switch";

    public static final String SUCCESS = "success";

    public static final String FAIL = "fail";

    public static final String WARN = "warn";

    public static final String START = "start";

    public static final String FINISH = "finish";

    public static final String WAITING = "waiting";

    public static final String EXECUTING = "executing";

    @Id
    private String id;

    private String version;

    private String application;

    private List<String> tenantIdList;

    private UserInfoDto user;

    private String deployTenant;

    private String type;

    private Boolean allowCustomPublish;

    private CompiledData compileData;

    private String deployNo;

    private String result;

    private String applicationName;

    private JSONObject applicationNameLang;

    private Date date;
    // 发布的目标环境
    private String envName;
    // 发布的入参信息
    private DeployParam deployParam;
    // 发布进度
    private BigDecimal process = BigDecimal.valueOf(0);

    private Boolean individual = false;

    private String createBy;
    private Date createDate;
    private String editBy;
    private Date editDate;
}
